/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index.hash;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.datapage.DataPageReader;
import org.apache.ignite.internal.pagememory.reuse.ReuseList;
import org.apache.ignite.internal.pagememory.tree.BplusTree;
import org.apache.ignite.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite.internal.pagememory.util.PageLockListener;
import org.apache.ignite.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptor;
import org.apache.ignite.internal.storage.pagememory.index.InlineUtils;
import org.apache.ignite.internal.storage.pagememory.index.hash.HashIndexRow;
import org.apache.ignite.internal.storage.pagememory.index.hash.HashIndexRowKey;
import org.apache.ignite.internal.storage.pagememory.index.hash.io.HashIndexTreeInnerIo;
import org.apache.ignite.internal.storage.pagememory.index.hash.io.HashIndexTreeIo;
import org.apache.ignite.internal.storage.pagememory.index.hash.io.HashIndexTreeLeafIo;
import org.apache.ignite.internal.storage.pagememory.index.hash.io.HashIndexTreeMetaIo;
import org.jetbrains.annotations.Nullable;

public class HashIndexTree
extends BplusTree<HashIndexRowKey, HashIndexRow> {
    private final DataPageReader dataPageReader;
    private final int inlineSize;

    private HashIndexTree(int grpId, String grpName, int partId, PageMemory pageMem, PageLockListener lockLsnr, AtomicLong globalRmvId, long metaPageId, @Nullable ReuseList reuseList) throws IgniteInternalCheckedException {
        super("HashIndexTree", grpId, grpName, partId, pageMem, lockLsnr, globalRmvId, metaPageId, reuseList);
        this.inlineSize = this.readInlineSizeFromMetaIo();
        this.dataPageReader = new DataPageReader(pageMem, grpId, this.statisticsHolder());
        this.init(false);
    }

    private HashIndexTree(int grpId, String grpName, int partId, PageMemory pageMem, PageLockListener lockLsnr, AtomicLong globalRmvId, long metaPageId, @Nullable ReuseList reuseList, StorageHashIndexDescriptor indexDescriptor) throws IgniteInternalCheckedException {
        super("HashIndexTree", grpId, grpName, partId, pageMem, lockLsnr, globalRmvId, metaPageId, reuseList);
        this.inlineSize = InlineUtils.binaryTupleInlineSize(this.pageSize(), 28, (StorageIndexDescriptor)indexDescriptor);
        this.dataPageReader = new DataPageReader(pageMem, grpId, this.statisticsHolder());
        this.init(true);
        this.writeInlineSizeToMetaIo(this.inlineSize);
    }

    private void init(boolean initNew) throws IgniteInternalCheckedException {
        this.setIos(HashIndexTreeInnerIo.VERSIONS.get(this.inlineSize), HashIndexTreeLeafIo.VERSIONS.get(this.inlineSize), HashIndexTreeMetaIo.VERSIONS);
        this.initTree(initNew);
    }

    public static HashIndexTree createNew(int grpId, String grpName, int partId, PageMemory pageMem, PageLockListener lockLsnr, AtomicLong globalRmvId, long metaPageId, @Nullable ReuseList reuseList, StorageHashIndexDescriptor indexDescriptor) throws IgniteInternalCheckedException {
        return new HashIndexTree(grpId, grpName, partId, pageMem, lockLsnr, globalRmvId, metaPageId, reuseList, indexDescriptor);
    }

    public static HashIndexTree restoreExisting(int grpId, String grpName, int partId, PageMemory pageMem, PageLockListener lockLsnr, AtomicLong globalRmvId, long metaPageId, @Nullable ReuseList reuseList) throws IgniteInternalCheckedException {
        return new HashIndexTree(grpId, grpName, partId, pageMem, lockLsnr, globalRmvId, metaPageId, reuseList);
    }

    public int partitionId() {
        return this.partId;
    }

    public DataPageReader dataPageReader() {
        return this.dataPageReader;
    }

    protected int compare(BplusIo<HashIndexRowKey> io, long pageAddr, int idx, HashIndexRowKey row) throws IgniteInternalCheckedException {
        HashIndexTreeIo hashIndexTreeIo = (HashIndexTreeIo)io;
        return hashIndexTreeIo.compare(this.dataPageReader, this.partId, pageAddr, idx, row);
    }

    public HashIndexRow getRow(BplusIo<HashIndexRowKey> io, long pageAddr, int idx, Object x) throws IgniteInternalCheckedException {
        HashIndexTreeIo hashIndexTreeIo = (HashIndexTreeIo)io;
        return hashIndexTreeIo.getRow(this.dataPageReader, this.partId, pageAddr, idx);
    }

    public int inlineSize() {
        return this.inlineSize;
    }

    private int readInlineSizeFromMetaIo() throws IgniteInternalCheckedException {
        Integer inlineSize = (Integer)this.read(this.metaPageId, (groupId, pageId, page, pageAddr, io, arg, intArg, statHolder) -> ((HashIndexTreeMetaIo)io).getInlineSize(pageAddr), null, 0, -1);
        assert (inlineSize != -1);
        return inlineSize;
    }

    private void writeInlineSizeToMetaIo(int inlineSize) throws IgniteInternalCheckedException {
        Boolean result = (Boolean)this.write(this.metaPageId, (groupId, pageId, page, pageAddr, io, arg, intArg, statHolder) -> {
            ((HashIndexTreeMetaIo)io).setInlineSize(pageAddr, inlineSize);
            return Boolean.TRUE;
        }, 0, Boolean.FALSE, this.statisticsHolder());
        assert (result == Boolean.TRUE) : result;
    }
}

