/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.impl.raft;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.metastorage.impl.raft.StartupMetaStorageSnapshotReader;
import org.apache.ignite.internal.metastorage.server.KeyValueStorage;
import org.apache.ignite.internal.raft.IndexWithTerm;
import org.apache.ignite.internal.raft.RaftGroupConfiguration;
import org.apache.ignite.internal.raft.RaftGroupConfigurationConverter;
import org.apache.ignite.internal.raft.storage.SnapshotStorageFactory;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.storage.SnapshotStorage;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotReader;
import org.apache.ignite.raft.jraft.storage.snapshot.local.LocalSnapshotStorage;
import org.jetbrains.annotations.Nullable;

public class MetaStorageSnapshotStorageFactory
implements SnapshotStorageFactory {
    private final KeyValueStorage storage;
    @Nullable
    private final RaftOutter.SnapshotMeta startupSnapshotMeta;
    private final RaftGroupConfigurationConverter configurationConverter = new RaftGroupConfigurationConverter();

    public MetaStorageSnapshotStorageFactory(KeyValueStorage storage) {
        this.storage = storage;
        this.startupSnapshotMeta = this.readStartupSnapshotMeta();
    }

    @Nullable
    private RaftOutter.SnapshotMeta readStartupSnapshotMeta() {
        IndexWithTerm indexWithTerm = this.storage.getIndexWithTerm();
        if (indexWithTerm == null) {
            return null;
        }
        byte[] configBytes = this.storage.getConfiguration();
        assert (configBytes != null);
        RaftGroupConfiguration configuration = this.configurationConverter.fromBytes(configBytes);
        assert (configuration != null);
        return new RaftMessagesFactory().snapshotMeta().lastIncludedIndex(indexWithTerm.index()).lastIncludedTerm(indexWithTerm.term()).peersList((Collection)configuration.peers()).oldPeersList((Collection)configuration.oldPeers()).learnersList((Collection)configuration.learners()).oldLearnersList((Collection)configuration.oldLearners()).build();
    }

    @Nullable
    public SnapshotStorage createSnapshotStorage(String uri, RaftOptions raftOptions) {
        return new LocalSnapshotStorage(uri, raftOptions){
            private final AtomicBoolean startupSnapshotOpened;
            {
                this.startupSnapshotOpened = new AtomicBoolean(false);
            }

            public SnapshotReader open() {
                if (this.startupSnapshotOpened.compareAndSet(false, true)) {
                    if (MetaStorageSnapshotStorageFactory.this.startupSnapshotMeta == null) {
                        return null;
                    }
                    return new StartupMetaStorageSnapshotReader(MetaStorageSnapshotStorageFactory.this.startupSnapshotMeta);
                }
                return super.open();
            }
        };
    }
}

