/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.UUID;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.WalStateProposeMessage;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public abstract class WalStateAbstractMessage
implements DiscoveryCustomMessage {
    private final IgniteUuid id = IgniteUuid.randomUuid();
    private final UUID opId;
    private int grpId;
    private IgniteUuid grpDepId;
    @GridToStringExclude
    private transient WalStateProposeMessage exchangeMsg;

    protected WalStateAbstractMessage(UUID opId, int grpId, IgniteUuid grpDepId) {
        this.opId = opId;
        this.grpId = grpId;
        this.grpDepId = grpDepId;
    }

    public UUID operationId() {
        return this.opId;
    }

    public int groupId() {
        return this.grpId;
    }

    public IgniteUuid groupDeploymentId() {
        return this.grpDepId;
    }

    public boolean needExchange() {
        return this.exchangeMsg != null;
    }

    @Nullable
    public WalStateProposeMessage exchangeMessage() {
        return this.exchangeMsg;
    }

    public void exchangeMessage(WalStateProposeMessage exchangeMsg) {
        this.exchangeMsg = exchangeMsg;
    }

    @Override
    public IgniteUuid id() {
        return this.id;
    }

    @Override
    @Nullable
    public DiscoveryCustomMessage ackMessage() {
        return null;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public DiscoCache createDiscoCache(GridDiscoveryManager mgr, AffinityTopologyVersion topVer, DiscoCache discoCache) {
        return discoCache.copy(topVer, null);
    }

    public String toString() {
        return S.toString(WalStateAbstractMessage.class, this);
    }
}

