/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import java.util.UUID;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NullableInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.UuidIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;

public class UuidInlineIndexKeyType
extends NullableInlineIndexKeyType<UuidIndexKey> {
    public UuidInlineIndexKeyType() {
        super(IndexKeyType.UUID, (short)16);
    }

    @Override
    public int compare0(long pageAddr, int off, IndexKey key) {
        UUID v = (UUID)key.key();
        long part1 = PageUtils.getLong(pageAddr, off + 1);
        int c = Integer.signum(Long.compare(part1, v.getMostSignificantBits()));
        if (c != 0) {
            return c;
        }
        long part2 = PageUtils.getLong(pageAddr, off + 9);
        return Integer.signum(Long.compare(part2, v.getLeastSignificantBits()));
    }

    @Override
    protected int put0(long pageAddr, int off, UuidIndexKey key, int maxSize) {
        UUID val = (UUID)key.key();
        PageUtils.putByte(pageAddr, off, (byte)this.type().code());
        PageUtils.putLong(pageAddr, off + 1, val.getMostSignificantBits());
        PageUtils.putLong(pageAddr, off + 9, val.getLeastSignificantBits());
        return this.keySize + 1;
    }

    @Override
    protected UuidIndexKey get0(long pageAddr, int off) {
        return new UuidIndexKey(new UUID(PageUtils.getLong(pageAddr, off + 1), PageUtils.getLong(pageAddr, off + 9)));
    }

    @Override
    protected int inlineSize0(UuidIndexKey val) {
        return this.keySize + 1;
    }
}

