/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.stream;

import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.stream.StreamMultipleTupleExtractor;
import org.apache.ignite.stream.StreamSingleTupleExtractor;
import org.apache.ignite.stream.StreamTupleExtractor;

public abstract class StreamAdapter<T, K, V> {
    private StreamSingleTupleExtractor<T, K, V> singleTupleExtractor;
    private StreamMultipleTupleExtractor<T, K, V> multipleTupleExtractor;
    private IgniteDataStreamer<K, V> stmr;
    protected Ignite ignite;

    protected StreamAdapter() {
    }

    protected StreamAdapter(IgniteDataStreamer<K, V> stmr, StreamSingleTupleExtractor<T, K, V> extractor) {
        this.stmr = stmr;
        this.singleTupleExtractor = extractor;
    }

    protected StreamAdapter(IgniteDataStreamer<K, V> stmr, StreamMultipleTupleExtractor<T, K, V> extractor) {
        this.stmr = stmr;
        this.multipleTupleExtractor = extractor;
    }

    public IgniteDataStreamer<K, V> getStreamer() {
        return this.stmr;
    }

    public void setStreamer(IgniteDataStreamer<K, V> stmr) {
        this.stmr = stmr;
    }

    @Deprecated
    public StreamTupleExtractor<T, K, V> getTupleExtractor() {
        if (this.singleTupleExtractor instanceof StreamTupleExtractor) {
            return (StreamTupleExtractor)this.singleTupleExtractor;
        }
        throw new IllegalArgumentException("This method is deprecated and only relevant if using an old StreamTupleExtractor; use getSingleTupleExtractor instead");
    }

    @Deprecated
    public void setTupleExtractor(StreamTupleExtractor<T, K, V> extractor) {
        if (this.multipleTupleExtractor != null) {
            throw new IllegalArgumentException("Multiple tuple extractor already set; cannot set both types at once.");
        }
        this.singleTupleExtractor = extractor;
    }

    public StreamSingleTupleExtractor<T, K, V> getSingleTupleExtractor() {
        return this.singleTupleExtractor;
    }

    public void setSingleTupleExtractor(StreamSingleTupleExtractor<T, K, V> singleTupleExtractor) {
        if (this.multipleTupleExtractor != null) {
            throw new IllegalArgumentException("Multiple tuple extractor already set; cannot set both types at once.");
        }
        this.singleTupleExtractor = singleTupleExtractor;
    }

    public StreamMultipleTupleExtractor<T, K, V> getMultipleTupleExtractor() {
        return this.multipleTupleExtractor;
    }

    public void setMultipleTupleExtractor(StreamMultipleTupleExtractor<T, K, V> multipleTupleExtractor) {
        if (this.singleTupleExtractor != null) {
            throw new IllegalArgumentException("Single tuple extractor already set; cannot set both types at once.");
        }
        this.multipleTupleExtractor = multipleTupleExtractor;
    }

    public Ignite getIgnite() {
        return this.ignite;
    }

    public void setIgnite(Ignite ignite) {
        this.ignite = ignite;
    }

    protected void addMessage(T msg) {
        if (this.multipleTupleExtractor == null) {
            Map.Entry<K, V> e = this.singleTupleExtractor.extract(msg);
            if (e != null) {
                this.stmr.addData(e);
            }
        } else {
            Map<K, V> m = this.multipleTupleExtractor.extract(msg);
            if (m != null && !m.isEmpty()) {
                this.stmr.addData(m);
            }
        }
    }
}

