/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.SortedIndexDefinition;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IndexQueryResultMeta
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private IndexKeyTypeSettings keyTypeSettings;
    private LinkedHashMap<String, IndexKeyDefinition> keyDefs;

    public IndexQueryResultMeta() {
    }

    public IndexQueryResultMeta(SortedIndexDefinition def, int critSize) {
        this.keyTypeSettings = def.keyTypeSettings();
        this.keyDefs = new LinkedHashMap();
        Iterator<Map.Entry<String, IndexKeyDefinition>> keys = def.indexKeyDefinitions().entrySet().iterator();
        for (int i = 0; i < critSize; ++i) {
            Map.Entry<String, IndexKeyDefinition> key = keys.next();
            this.keyDefs.put(key.getKey(), key.getValue());
        }
    }

    public IndexKeyTypeSettings keyTypeSettings() {
        return this.keyTypeSettings;
    }

    public LinkedHashMap<String, IndexKeyDefinition> keyDefinitions() {
        return this.keyDefs;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.keyTypeSettings);
        U.writeMap(out, this.keyDefs);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.keyTypeSettings = (IndexKeyTypeSettings)in.readObject();
        this.keyDefs = U.readLinkedMap(in);
    }
}

