/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.AutomatonProvider;
import org.apache.lucene.util.automaton.RegExp;

public class RegexpQuery
extends AutomatonQuery {
    private static AutomatonProvider defaultProvider = new AutomatonProvider(){

        @Override
        public Automaton getAutomaton(String name) {
            return null;
        }
    };

    public RegexpQuery(Term term) {
        this(term, 255);
    }

    public RegexpQuery(Term term, int flags) {
        this(term, flags, defaultProvider, 10000);
    }

    public RegexpQuery(Term term, int flags, int determinizeWorkLimit) {
        this(term, flags, defaultProvider, determinizeWorkLimit);
    }

    public RegexpQuery(Term term, int syntax_flags, int match_flags, int determinizeWorkLimit) {
        this(term, syntax_flags, match_flags, defaultProvider, determinizeWorkLimit);
    }

    public RegexpQuery(Term term, int syntax_flags, AutomatonProvider provider, int determinizeWorkLimit) {
        this(term, syntax_flags, 0, provider, determinizeWorkLimit);
    }

    public RegexpQuery(Term term, int syntax_flags, int match_flags, AutomatonProvider provider, int determinizeWorkLimit) {
        super(term, new RegExp(term.text(), syntax_flags, match_flags).toAutomaton(provider, determinizeWorkLimit), determinizeWorkLimit);
    }

    public Term getRegexp() {
        return this.term;
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append('/');
        buffer.append(this.term.text());
        buffer.append('/');
        return buffer.toString();
    }
}

