/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.geom.util.GeometryTransformer;

public class AddZTransformer
extends GeometryTransformer {
    private final double zToAdd;

    public AddZTransformer(double zToAdd) {
        this.zToAdd = zToAdd;
    }

    protected CoordinateSequence transformCoordinates(CoordinateSequence coordinates, Geometry parent) {
        Coordinate[] newCoordinates = new Coordinate[coordinates.size()];
        for (int i = 0; i < coordinates.size(); ++i) {
            Coordinate current = coordinates.getCoordinate(i);
            if (Double.isNaN(current.z)) continue;
            newCoordinates[i] = new Coordinate(current.x, current.y, current.z + this.zToAdd);
        }
        return new CoordinateArraySequence(newCoordinates);
    }
}

