/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.jets3t.service.impl.rest;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.Constants;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.Jets3tProperties;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.ServiceException;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.acl.CanonicalGrantee;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.acl.EmailAddressGrantee;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.acl.GrantAndPermission;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.acl.GranteeInterface;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.acl.GroupGrantee;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.acl.Permission;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.acl.gs.GSAccessControlList;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.impl.rest.AccessControlListHandler;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.impl.rest.DefaultXmlHandler;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.impl.rest.GSAccessControlListHandler;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.impl.rest.SimpleHandler;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.BaseVersionOrDeleteMarker;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.GSBucket;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.GSBucketLoggingStatus;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.GSObject;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.GSOwner;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.MultipartCompleted;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.MultipartPart;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.MultipartUpload;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.MultipleDeleteResult;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.NotificationConfig;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.S3Bucket;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.S3BucketLoggingStatus;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.S3BucketVersioningStatus;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.S3DeleteMarker;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.S3Object;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.S3Owner;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.S3Version;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.StorageBucket;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.StorageBucketLoggingStatus;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.StorageObject;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.StorageOwner;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.WebsiteConfig;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.utils.ServiceUtils;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlResponsesSaxParser {
    private static final Log log = LogFactory.getLog(XmlResponsesSaxParser.class);
    private XMLReader xr = null;
    private Jets3tProperties properties = null;
    private boolean isGoogleStorageMode = false;

    public XmlResponsesSaxParser(Jets3tProperties properties, boolean returnGoogleStorageObjects) throws ServiceException {
        this.properties = properties;
        this.isGoogleStorageMode = returnGoogleStorageObjects;
        this.xr = ServiceUtils.loadXMLReader();
    }

    protected StorageBucket newBucket() {
        if (this.isGoogleStorageMode) {
            return new GSBucket();
        }
        return new S3Bucket();
    }

    protected StorageObject newObject() {
        if (this.isGoogleStorageMode) {
            return new GSObject();
        }
        return new S3Object();
    }

    protected StorageOwner newOwner() {
        if (this.isGoogleStorageMode) {
            return new GSOwner();
        }
        return new S3Owner();
    }

    protected void parseXmlInputStream(DefaultHandler handler, InputStream inputStream) throws ServiceException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing XML response document with handler: " + handler.getClass()));
            }
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            this.xr.setContentHandler(handler);
            this.xr.setErrorHandler(handler);
            this.xr.parse(new InputSource(breader));
            inputStream.close();
        }
        catch (Throwable t) {
            block5: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Unable to close response InputStream up after XML parse failure", (Throwable)e);
                }
            }
            throw new ServiceException("Failed to parse XML document with handler " + handler.getClass(), t);
        }
    }

    protected InputStream sanitizeXmlDocument(DefaultHandler handler, InputStream inputStream) throws ServiceException {
        if (!this.properties.getBoolProperty("xmlparser.sanitize-listings", true)) {
            return inputStream;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sanitizing XML document destined for handler " + handler.getClass()));
        }
        ByteArrayInputStream sanitizedInputStream = null;
        try {
            StringBuilder listingDocBuffer = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            char[] buf = new char[8192];
            int read = -1;
            while ((read = br.read(buf)) != -1) {
                listingDocBuffer.append(buf, 0, read);
            }
            br.close();
            String listingDoc = listingDocBuffer.toString().replaceAll("\r", "&#013;");
            sanitizedInputStream = new ByteArrayInputStream(listingDoc.getBytes(Constants.DEFAULT_ENCODING));
        }
        catch (Throwable t) {
            block7: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block7;
                    log.error((Object)"Unable to close response InputStream after failure sanitizing XML document", (Throwable)e);
                }
            }
            throw new ServiceException("Failed to sanitize XML document destined for handler " + handler.getClass(), t);
        }
        return sanitizedInputStream;
    }

    public ListBucketHandler parseListBucketResponse(InputStream inputStream) throws ServiceException {
        ListBucketHandler handler = new ListBucketHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public ListAllMyBucketsHandler parseListMyBucketsResponse(InputStream inputStream) throws ServiceException {
        ListAllMyBucketsHandler handler = new ListAllMyBucketsHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public AccessControlListHandler parseAccessControlListResponse(InputStream inputStream) throws ServiceException {
        AccessControlListHandler handler = this.isGoogleStorageMode ? new GSAccessControlListHandler() : new AccessControlListHandler();
        return this.parseAccessControlListResponse(inputStream, handler);
    }

    public AccessControlListHandler parseAccessControlListResponse(InputStream inputStream, AccessControlListHandler handler) throws ServiceException {
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketLoggingStatusHandler parseLoggingStatusResponse(InputStream inputStream) throws ServiceException {
        BucketLoggingStatusHandler handler = this.isGoogleStorageMode ? new GSBucketLoggingStatusHandler() : new S3BucketLoggingStatusHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketLoggingStatusHandler parseLoggingStatusResponse(InputStream inputStream, BucketLoggingStatusHandler handler) throws ServiceException {
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public String parseBucketLocationResponse(InputStream inputStream) throws ServiceException {
        BucketLocationHandler handler = new BucketLocationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler.getLocation();
    }

    public CopyObjectResultHandler parseCopyObjectResponse(InputStream inputStream) throws ServiceException {
        CopyObjectResultHandler handler = new CopyObjectResultHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public boolean parseRequestPaymentConfigurationResponse(InputStream inputStream) throws ServiceException {
        RequestPaymentConfigurationHandler handler = new RequestPaymentConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler.isRequesterPays();
    }

    public S3BucketVersioningStatus parseVersioningConfigurationResponse(InputStream inputStream) throws ServiceException {
        VersioningConfigurationHandler handler = new VersioningConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler.getVersioningStatus();
    }

    public ListVersionsResultsHandler parseListVersionsResponse(InputStream inputStream) throws ServiceException {
        ListVersionsResultsHandler handler = new ListVersionsResultsHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public MultipartUpload parseInitiateMultipartUploadResult(InputStream inputStream) throws ServiceException {
        MultipartUploadResultHandler handler = new MultipartUploadResultHandler(this.xr);
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler.getMultipartUpload();
    }

    public MultipartPart parseMultipartUploadPartCopyResult(InputStream inputStream) throws ServiceException {
        MultipartPartResultHandler handler = new MultipartPartResultHandler(this.xr);
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler.getMultipartPart();
    }

    public ListMultipartUploadsResultHandler parseListMultipartUploadsResult(InputStream inputStream) throws ServiceException {
        ListMultipartUploadsResultHandler handler = new ListMultipartUploadsResultHandler(this.xr);
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public ListMultipartPartsResultHandler parseListMultipartPartsResult(InputStream inputStream) throws ServiceException {
        ListMultipartPartsResultHandler handler = new ListMultipartPartsResultHandler(this.xr);
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public CompleteMultipartUploadResultHandler parseCompleteMultipartUploadResult(InputStream inputStream) throws ServiceException {
        CompleteMultipartUploadResultHandler handler = new CompleteMultipartUploadResultHandler(this.xr);
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public WebsiteConfig parseWebsiteConfigurationResponse(InputStream inputStream) throws ServiceException {
        WebsiteConfigurationHandler handler = new WebsiteConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler.getWebsiteConfig();
    }

    public NotificationConfig parseNotificationConfigurationResponse(InputStream inputStream) throws ServiceException {
        NotificationConfigurationHandler handler = new NotificationConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler.getNotificationConfig();
    }

    public MultipleDeleteResult parseMultipleDeleteResponse(InputStream inputStream) throws ServiceException {
        MultipleDeleteResultHandler handler = new MultipleDeleteResultHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler.getMultipleDeleteResult();
    }

    public class MultipleDeleteResultHandler
    extends DefaultXmlHandler {
        private MultipleDeleteResult result = new MultipleDeleteResult();
        private List<MultipleDeleteResult.DeletedObjectResult> deletedObjectResults = new ArrayList<MultipleDeleteResult.DeletedObjectResult>();
        private List<MultipleDeleteResult.ErrorResult> errorResults = new ArrayList<MultipleDeleteResult.ErrorResult>();
        private boolean inDeleted;
        private boolean inError;
        private String key;
        private String version;
        private String deleteMarkerVersion;
        private String errorCode;
        private String message;
        private Boolean withDeleteMarker;

        public MultipleDeleteResult getMultipleDeleteResult() {
            return this.result;
        }

        public void startElement(String name) {
            if ("Deleted".equals(name)) {
                this.inDeleted = true;
            } else if ("Error".equals(name)) {
                this.inError = true;
            }
        }

        public void endElement(String name, String elementText) {
            if ("Key".equals(name)) {
                this.key = elementText;
            } else if ("VersionId".equals(name)) {
                this.version = elementText;
            } else if ("DeleteMarker".equals(name)) {
                this.withDeleteMarker = Boolean.valueOf(elementText);
            } else if ("DeleteMarkerVersionId".equals(name)) {
                this.deleteMarkerVersion = elementText;
            } else if ("Code".equals(name)) {
                this.errorCode = elementText;
            } else if ("Message".equals(name)) {
                this.message = elementText;
            } else if ("Deleted".equals(name)) {
                MultipleDeleteResult multipleDeleteResult = this.result;
                multipleDeleteResult.getClass();
                this.deletedObjectResults.add(new MultipleDeleteResult.DeletedObjectResult(multipleDeleteResult, this.key, this.version, this.withDeleteMarker, this.deleteMarkerVersion));
                this.inDeleted = false;
                this.message = null;
                this.errorCode = null;
                this.deleteMarkerVersion = null;
                this.version = null;
                this.key = null;
                this.withDeleteMarker = null;
            } else if ("Error".equals(name)) {
                MultipleDeleteResult multipleDeleteResult = this.result;
                multipleDeleteResult.getClass();
                this.errorResults.add(new MultipleDeleteResult.ErrorResult(multipleDeleteResult, this.key, this.version, this.errorCode, this.message));
                this.inError = false;
                this.message = null;
                this.errorCode = null;
                this.deleteMarkerVersion = null;
                this.version = null;
                this.key = null;
                this.withDeleteMarker = null;
            } else if (name.equals("DeleteResult")) {
                this.result.setDeletedObjectResults(this.deletedObjectResults);
                this.result.setErrorResults(this.errorResults);
            }
        }
    }

    public class NotificationConfigurationHandler
    extends DefaultXmlHandler {
        private NotificationConfig config = new NotificationConfig();
        private String lastTopic = null;
        private String lastEvent = null;

        public NotificationConfig getNotificationConfig() {
            return this.config;
        }

        public void endElement(String name, String elementText) {
            if (name.equals("Topic")) {
                this.lastTopic = elementText;
            } else if (name.equals("Event")) {
                this.lastEvent = elementText;
                NotificationConfig notificationConfig = this.config;
                notificationConfig.getClass();
                this.config.addTopicConfig(new NotificationConfig.TopicConfig(notificationConfig, this.lastTopic, this.lastEvent));
            } else if (name.equals("NotificationConfiguration")) {
                // empty if block
            }
        }
    }

    public class WebsiteConfigurationHandler
    extends DefaultXmlHandler {
        private WebsiteConfig config = null;
        private String indexDocumentSuffix = null;
        private String errorDocumentKey = null;

        public WebsiteConfig getWebsiteConfig() {
            return this.config;
        }

        public void endElement(String name, String elementText) {
            if (name.equals("Suffix")) {
                this.indexDocumentSuffix = elementText;
            } else if (name.equals("Key")) {
                this.errorDocumentKey = elementText;
            } else if (name.equals("WebsiteConfiguration")) {
                this.config = new WebsiteConfig(this.indexDocumentSuffix, this.errorDocumentKey);
            }
        }
    }

    public class CompleteMultipartUploadErrorHandler
    extends SimpleHandler {
        private String code;
        private String message;
        private String etag;
        private Long minSizeAllowed;
        private Long proposedSize;
        private String hostId;
        private Integer partNumber;
        private String requestId;

        public CompleteMultipartUploadErrorHandler(XMLReader xr) {
            super(xr);
            this.code = null;
            this.message = null;
            this.etag = null;
            this.minSizeAllowed = null;
            this.proposedSize = null;
            this.hostId = null;
            this.partNumber = null;
            this.requestId = null;
        }

        public ServiceException getServiceException() {
            String fullMessage = this.message + ": PartNumber=" + this.partNumber + ", MinSizeAllowed=" + this.minSizeAllowed + ", ProposedSize=" + this.proposedSize + ", ETag=" + this.etag;
            ServiceException e = new ServiceException(fullMessage);
            e.setErrorCode(this.code);
            e.setErrorMessage(this.message);
            e.setErrorHostId(this.hostId);
            e.setErrorRequestId(this.requestId);
            return e;
        }

        public void endCode(String text) {
            this.code = text;
        }

        public void endMessage(String text) {
            this.message = text;
        }

        public void endETag(String text) {
            this.etag = text;
        }

        public void endMinSizeAllowed(String text) {
            this.minSizeAllowed = Long.parseLong(text);
        }

        public void endProposedSize(String text) {
            this.proposedSize = Long.parseLong(text);
        }

        public void endHostId(String text) {
            this.hostId = text;
        }

        public void endPartNumber(String text) {
            this.partNumber = Integer.parseInt(text);
        }

        public void endRequestId(String text) {
            this.requestId = text;
        }

        public void endError(String text) {
            this.returnControlToParentHandler();
        }
    }

    public class CompleteMultipartUploadResultHandler
    extends SimpleHandler {
        private String location;
        private String bucketName;
        private String objectKey;
        private String etag;
        private ServiceException serviceException;

        public CompleteMultipartUploadResultHandler(XMLReader xr) {
            super(xr);
            this.serviceException = null;
        }

        public MultipartCompleted getMultipartCompleted() {
            return new MultipartCompleted(this.location, this.bucketName, this.objectKey, this.etag);
        }

        public ServiceException getServiceException() {
            return this.serviceException;
        }

        public void endLocation(String text) {
            this.location = text;
        }

        public void endBucket(String text) {
            this.bucketName = text;
        }

        public void endKey(String text) {
            this.objectKey = text;
        }

        public void endETag(String text) {
            this.etag = text;
        }

        public void startError() {
            this.transferControlToHandler(new CompleteMultipartUploadErrorHandler(XmlResponsesSaxParser.this.xr));
        }

        public void controlReturned(SimpleHandler childHandler) {
            this.serviceException = ((CompleteMultipartUploadErrorHandler)childHandler).getServiceException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ListMultipartPartsResultHandler
    extends SimpleHandler {
        private final List<MultipartPart> parts;
        private String bucketName;
        private String objectKey;
        private String uploadId;
        private S3Owner initiator;
        private S3Owner owner;
        private String storageClass;
        private String partNumberMarker;
        private String nextPartNumberMarker;
        private int maxParts;
        private boolean isTruncated;
        private boolean inInitiator;

        public ListMultipartPartsResultHandler(XMLReader xr) {
            super(xr);
            this.parts = new ArrayList<MultipartPart>();
            this.bucketName = null;
            this.objectKey = null;
            this.uploadId = null;
            this.initiator = null;
            this.owner = null;
            this.storageClass = null;
            this.partNumberMarker = null;
            this.nextPartNumberMarker = null;
            this.maxParts = 1000;
            this.isTruncated = false;
            this.inInitiator = false;
        }

        public List<MultipartPart> getMultipartPartList() {
            return this.parts;
        }

        public boolean isTruncated() {
            return this.isTruncated;
        }

        public String getBucketName() {
            return this.bucketName;
        }

        public String getObjectKey() {
            return this.objectKey;
        }

        public String getUploadId() {
            return this.uploadId;
        }

        public S3Owner getInitiator() {
            return this.initiator;
        }

        public S3Owner getOwner() {
            return this.owner;
        }

        public String getStorageClass() {
            return this.storageClass;
        }

        public String getPartNumberMarker() {
            return this.partNumberMarker;
        }

        public String getNextPartNumberMarker() {
            return this.nextPartNumberMarker;
        }

        public int getMaxParts() {
            return this.maxParts;
        }

        public void startPart() {
            this.transferControlToHandler(new MultipartPartResultHandler(XmlResponsesSaxParser.this.xr));
        }

        @Override
        public void controlReturned(SimpleHandler childHandler) {
            if (childHandler instanceof MultipartPartResultHandler) {
                this.parts.add(((MultipartPartResultHandler)childHandler).getMultipartPart());
            } else if (this.inInitiator) {
                this.initiator = (S3Owner)((OwnerHandler)childHandler).getOwner();
            } else {
                this.owner = (S3Owner)((OwnerHandler)childHandler).getOwner();
            }
        }

        public void startInitiator() {
            this.inInitiator = true;
            this.transferControlToHandler(new OwnerHandler(XmlResponsesSaxParser.this.xr));
        }

        public void startOwner() {
            this.inInitiator = false;
            this.transferControlToHandler(new OwnerHandler(XmlResponsesSaxParser.this.xr));
        }

        public void endBucket(String text) {
            this.bucketName = text;
        }

        public void endKey(String text) {
            this.objectKey = text;
        }

        public void endStorageClass(String text) {
            this.storageClass = text;
        }

        public void endUploadId(String text) {
            this.uploadId = text;
        }

        public void endPartNumberMarker(String text) {
            this.partNumberMarker = text;
        }

        public void endNextPartNumberMarker(String text) {
            this.nextPartNumberMarker = text;
        }

        public void endMaxParts(String text) {
            this.maxParts = Integer.parseInt(text);
        }

        public void endIsTruncated(String text) {
            this.isTruncated = "true".equalsIgnoreCase(text);
        }
    }

    public class MultipartPartResultHandler
    extends SimpleHandler {
        private Integer partNumber;
        private Date lastModified;
        private String etag;
        private Long size;

        public MultipartPartResultHandler(XMLReader xr) {
            super(xr);
            this.partNumber = -1;
            this.size = -1L;
        }

        public MultipartPart getMultipartPart() {
            return new MultipartPart(this.partNumber, this.lastModified, this.etag, this.size);
        }

        public void endPartNumber(String text) {
            this.partNumber = Integer.parseInt(text);
        }

        public void endLastModified(String text) throws ParseException {
            this.lastModified = ServiceUtils.parseIso8601Date(text);
        }

        public void endETag(String text) {
            this.etag = text;
        }

        public void endSize(String text) {
            this.size = Long.parseLong(text);
        }

        public void endPart(String text) {
            this.returnControlToParentHandler();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ListMultipartUploadsResultHandler
    extends SimpleHandler {
        private final List<MultipartUpload> uploads;
        private final List<String> commonPrefixes;
        private boolean insideCommonPrefixes;
        private String bucketName;
        private String keyMarker;
        private String uploadIdMarker;
        private String nextKeyMarker;
        private String nextUploadIdMarker;
        private int maxUploads;
        private boolean isTruncated;

        public ListMultipartUploadsResultHandler(XMLReader xr) {
            super(xr);
            this.uploads = new ArrayList<MultipartUpload>();
            this.commonPrefixes = new ArrayList<String>();
            this.bucketName = null;
            this.keyMarker = null;
            this.uploadIdMarker = null;
            this.nextKeyMarker = null;
            this.nextUploadIdMarker = null;
            this.maxUploads = 1000;
            this.isTruncated = false;
        }

        public List<MultipartUpload> getMultipartUploadList() {
            for (MultipartUpload upload : this.uploads) {
                upload.setBucketName(this.bucketName);
            }
            return this.uploads;
        }

        public boolean isTruncated() {
            return this.isTruncated;
        }

        public String getKeyMarker() {
            return this.keyMarker;
        }

        public String getUploadIdMarker() {
            return this.uploadIdMarker;
        }

        public String getNextKeyMarker() {
            return this.nextKeyMarker;
        }

        public String getNextUploadIdMarker() {
            return this.nextUploadIdMarker;
        }

        public int getMaxUploads() {
            return this.maxUploads;
        }

        public String[] getCommonPrefixes() {
            return this.commonPrefixes.toArray(new String[this.commonPrefixes.size()]);
        }

        public void startUpload() {
            this.transferControlToHandler(new MultipartUploadResultHandler(XmlResponsesSaxParser.this.xr));
        }

        public void startCommonPrefixes() {
            this.insideCommonPrefixes = true;
        }

        @Override
        public void controlReturned(SimpleHandler childHandler) {
            this.uploads.add(((MultipartUploadResultHandler)childHandler).getMultipartUpload());
        }

        public void endBucket(String text) {
            this.bucketName = text;
        }

        public void endKeyMarker(String text) {
            this.keyMarker = text;
        }

        public void endUploadIdMarker(String text) {
            this.uploadIdMarker = text;
        }

        public void endNextKeyMarker(String text) {
            this.nextKeyMarker = text;
        }

        public void endNextUploadIdMarker(String text) {
            this.nextUploadIdMarker = text;
        }

        public void endMaxUploads(String text) {
            this.maxUploads = Integer.parseInt(text);
        }

        public void endIsTruncated(String text) {
            this.isTruncated = "true".equalsIgnoreCase(text);
        }

        public void endPrefix(String text) {
            if (this.insideCommonPrefixes) {
                this.commonPrefixes.add(text);
            }
        }

        public void endCommonPrefixes() {
            this.insideCommonPrefixes = false;
        }
    }

    public class MultipartUploadResultHandler
    extends SimpleHandler {
        private String uploadId;
        private String bucketName;
        private String objectKey;
        private String storageClass;
        private S3Owner owner;
        private S3Owner initiator;
        private Date initiatedDate;
        private boolean inInitiator;

        public MultipartUploadResultHandler(XMLReader xr) {
            super(xr);
            this.inInitiator = false;
        }

        public MultipartUpload getMultipartUpload() {
            if (this.initiatedDate != null) {
                return new MultipartUpload(this.uploadId, this.objectKey, this.storageClass, this.initiator, this.owner, this.initiatedDate);
            }
            return new MultipartUpload(this.uploadId, this.bucketName, this.objectKey);
        }

        public void endUploadId(String text) {
            this.uploadId = text;
        }

        public void endBucket(String text) {
            this.bucketName = text;
        }

        public void endKey(String text) {
            this.objectKey = text;
        }

        public void endStorageClass(String text) {
            this.storageClass = text;
        }

        public void endInitiated(String text) throws ParseException {
            this.initiatedDate = ServiceUtils.parseIso8601Date(text);
        }

        public void startOwner() {
            this.inInitiator = false;
            this.transferControlToHandler(new OwnerHandler(XmlResponsesSaxParser.this.xr));
        }

        public void startInitiator() {
            this.inInitiator = true;
            this.transferControlToHandler(new OwnerHandler(XmlResponsesSaxParser.this.xr));
        }

        public void controlReturned(SimpleHandler childHandler) {
            if (this.inInitiator) {
                this.owner = (S3Owner)((OwnerHandler)childHandler).getOwner();
            } else {
                this.initiator = (S3Owner)((OwnerHandler)childHandler).getOwner();
            }
        }

        public void endUpload(String text) {
            this.returnControlToParentHandler();
        }
    }

    public class OwnerHandler
    extends SimpleHandler {
        private String id;
        private String displayName;

        public OwnerHandler(XMLReader xr) {
            super(xr);
        }

        public StorageOwner getOwner() {
            StorageOwner owner = XmlResponsesSaxParser.this.newOwner();
            owner.setId(this.id);
            owner.setDisplayName(this.displayName);
            return owner;
        }

        public void endID(String text) {
            this.id = text;
        }

        public void endDisplayName(String text) {
            this.displayName = text;
        }

        public void endOwner(String text) {
            this.returnControlToParentHandler();
        }

        public void endInitiator(String text) {
            this.returnControlToParentHandler();
        }
    }

    public class ListVersionsResultsHandler
    extends DefaultXmlHandler {
        private final List<BaseVersionOrDeleteMarker> items = new ArrayList<BaseVersionOrDeleteMarker>();
        private final List<String> commonPrefixes = new ArrayList<String>();
        private String key = null;
        private String versionId = null;
        private boolean isLatest = false;
        private Date lastModified = null;
        private StorageOwner owner = null;
        private String etag = null;
        private long size = 0L;
        private String storageClass = null;
        private boolean insideCommonPrefixes = false;
        private String bucketName = null;
        private String requestPrefix = null;
        private String keyMarker = null;
        private String versionIdMarker = null;
        private long requestMaxKeys = 0L;
        private boolean listingTruncated = false;
        private String nextMarker = null;
        private String nextVersionIdMarker = null;

        public boolean isListingTruncated() {
            return this.listingTruncated;
        }

        public BaseVersionOrDeleteMarker[] getItems() {
            return this.items.toArray(new BaseVersionOrDeleteMarker[this.items.size()]);
        }

        public String[] getCommonPrefixes() {
            return this.commonPrefixes.toArray(new String[this.commonPrefixes.size()]);
        }

        public String getRequestPrefix() {
            return this.requestPrefix;
        }

        public String getKeyMarker() {
            return this.keyMarker;
        }

        public String getVersionIdMarker() {
            return this.versionIdMarker;
        }

        public String getNextKeyMarker() {
            return this.nextMarker;
        }

        public String getNextVersionIdMarker() {
            return this.nextVersionIdMarker;
        }

        public long getRequestMaxKeys() {
            return this.requestMaxKeys;
        }

        public void startElement(String name) {
            if (name.equals("Owner")) {
                this.owner = null;
            } else if (name.equals("CommonPrefixes")) {
                this.insideCommonPrefixes = true;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void endElement(String name, String elementText) {
            if (name.equals("Name")) {
                this.bucketName = elementText;
                if (!log.isDebugEnabled()) return;
                log.debug((Object)("Examining listing for bucket: " + this.bucketName));
                return;
            } else if (!this.insideCommonPrefixes && name.equals("Prefix")) {
                this.requestPrefix = elementText;
                return;
            } else if (name.equals("KeyMarker")) {
                this.keyMarker = elementText;
                return;
            } else if (name.equals("NextKeyMarker")) {
                this.nextMarker = elementText;
                return;
            } else if (name.equals("VersionIdMarker")) {
                this.versionIdMarker = elementText;
                return;
            } else if (name.equals("NextVersionIdMarker")) {
                this.nextVersionIdMarker = elementText;
                return;
            } else if (name.equals("MaxKeys")) {
                this.requestMaxKeys = Long.parseLong(elementText);
                return;
            } else if (name.equals("IsTruncated")) {
                String isTruncatedStr = elementText.toLowerCase(Locale.getDefault());
                if (isTruncatedStr.startsWith("false")) {
                    this.listingTruncated = false;
                    return;
                } else {
                    if (!isTruncatedStr.startsWith("true")) throw new RuntimeException("Invalid value for IsTruncated field: " + isTruncatedStr);
                    this.listingTruncated = true;
                }
                return;
            } else if (name.equals("Version")) {
                S3Version item = new S3Version(this.key, this.versionId, this.isLatest, this.lastModified, (S3Owner)this.owner, this.etag, this.size, this.storageClass);
                this.items.add(item);
                return;
            } else if (name.equals("DeleteMarker")) {
                S3DeleteMarker item = new S3DeleteMarker(this.key, this.versionId, this.isLatest, this.lastModified, (S3Owner)this.owner);
                this.items.add(item);
                return;
            } else if (name.equals("Key")) {
                this.key = elementText;
                return;
            } else if (name.equals("VersionId")) {
                this.versionId = elementText;
                return;
            } else if (name.equals("IsLatest")) {
                this.isLatest = "true".equals(elementText);
                return;
            } else if (name.equals("LastModified")) {
                try {
                    this.lastModified = ServiceUtils.parseIso8601Date(elementText);
                    return;
                }
                catch (ParseException e) {
                    throw new RuntimeException("Non-ISO8601 date for LastModified in bucket's versions listing output: " + elementText, e);
                }
            } else if (name.equals("ETag")) {
                this.etag = elementText;
                return;
            } else if (name.equals("Size")) {
                this.size = Long.parseLong(elementText);
                return;
            } else if (name.equals("StorageClass")) {
                this.storageClass = elementText;
                return;
            } else if (name.equals("ID")) {
                this.owner = XmlResponsesSaxParser.this.newOwner();
                this.owner.setId(elementText);
                return;
            } else if (name.equals("DisplayName")) {
                this.owner.setDisplayName(elementText);
                return;
            } else if (this.insideCommonPrefixes && name.equals("Prefix")) {
                this.commonPrefixes.add(elementText);
                return;
            } else {
                if (!name.equals("CommonPrefixes")) return;
                this.insideCommonPrefixes = false;
            }
        }
    }

    public class VersioningConfigurationHandler
    extends DefaultXmlHandler {
        private S3BucketVersioningStatus versioningStatus = null;
        private String status = null;
        private String mfaStatus = null;

        public S3BucketVersioningStatus getVersioningStatus() {
            return this.versioningStatus;
        }

        public void endElement(String name, String elementText) {
            if (name.equals("Status")) {
                this.status = elementText;
            } else if (name.equals("MfaDelete")) {
                this.mfaStatus = elementText;
            } else if (name.equals("VersioningConfiguration")) {
                this.versioningStatus = new S3BucketVersioningStatus("Enabled".equals(this.status), "Enabled".equals(this.mfaStatus));
            }
        }
    }

    public class RequestPaymentConfigurationHandler
    extends DefaultXmlHandler {
        private String payer = null;

        public boolean isRequesterPays() {
            return "Requester".equals(this.payer);
        }

        public void endElement(String name, String elementText) {
            if (name.equals("Payer")) {
                this.payer = elementText;
            }
        }
    }

    public class CopyObjectResultHandler
    extends DefaultXmlHandler {
        private String etag = null;
        private Date lastModified = null;
        private String errorCode = null;
        private String errorMessage = null;
        private String errorRequestId = null;
        private String errorHostId = null;
        private boolean receivedErrorResponse = false;

        public Date getLastModified() {
            return this.lastModified;
        }

        public String getETag() {
            return this.etag;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getErrorHostId() {
            return this.errorHostId;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getErrorRequestId() {
            return this.errorRequestId;
        }

        public boolean isErrorResponse() {
            return this.receivedErrorResponse;
        }

        public void startElement(String name) {
            if (name.equals("CopyObjectResult")) {
                this.receivedErrorResponse = false;
            } else if (name.equals("Error")) {
                this.receivedErrorResponse = true;
            }
        }

        public void endElement(String name, String elementText) {
            if (name.equals("LastModified")) {
                try {
                    this.lastModified = ServiceUtils.parseIso8601Date(elementText);
                }
                catch (ParseException e) {
                    throw new RuntimeException("Non-ISO8601 date for LastModified in copy object output: " + elementText, e);
                }
            } else if (name.equals("ETag")) {
                this.etag = elementText;
            } else if (name.equals("Code")) {
                this.errorCode = elementText;
            } else if (name.equals("Message")) {
                this.errorMessage = elementText;
            } else if (name.equals("RequestId")) {
                this.errorRequestId = elementText;
            } else if (name.equals("HostId")) {
                this.errorHostId = elementText;
            }
        }
    }

    public class BucketLocationHandler
    extends DefaultXmlHandler {
        private String location = null;

        public String getLocation() {
            return this.location;
        }

        public void endElement(String name, String elementText) {
            if (name.equals("LocationConstraint")) {
                this.location = elementText.length() == 0 ? null : elementText;
            }
        }
    }

    public class GSBucketLoggingStatusHandler
    extends BucketLoggingStatusHandler {
        public void startElement(String name) {
            if (name.equals("Logging")) {
                this.bucketLoggingStatus = new GSBucketLoggingStatus();
            }
        }

        public void endElement(String name, String elementText) {
            if (name.equals("LogBucket")) {
                this.bucketLoggingStatus.setTargetBucketName(elementText);
            } else if (name.equals("LogObjectPrefix")) {
                this.bucketLoggingStatus.setLogfilePrefix(elementText);
            } else if (name.equals("PredefinedAcl")) {
                if (elementText.equals(GSAccessControlList.REST_CANNED_PRIVATE.getValueForRESTHeaderACL())) {
                    ((GSBucketLoggingStatus)this.bucketLoggingStatus).setPredefinedAcl(GSAccessControlList.REST_CANNED_PRIVATE);
                } else if (elementText.equals(GSAccessControlList.REST_CANNED_PUBLIC_READ.getValueForRESTHeaderACL())) {
                    ((GSBucketLoggingStatus)this.bucketLoggingStatus).setPredefinedAcl(GSAccessControlList.REST_CANNED_PUBLIC_READ);
                } else if (elementText.equals(GSAccessControlList.REST_CANNED_PUBLIC_READ_WRITE.getValueForRESTHeaderACL())) {
                    ((GSBucketLoggingStatus)this.bucketLoggingStatus).setPredefinedAcl(GSAccessControlList.REST_CANNED_PUBLIC_READ_WRITE);
                } else if (elementText.equals(GSAccessControlList.REST_CANNED_AUTHENTICATED_READ.getValueForRESTHeaderACL())) {
                    ((GSBucketLoggingStatus)this.bucketLoggingStatus).setPredefinedAcl(GSAccessControlList.REST_CANNED_AUTHENTICATED_READ);
                } else if (elementText.equals(GSAccessControlList.REST_CANNED_BUCKET_OWNER_READ.getValueForRESTHeaderACL())) {
                    ((GSBucketLoggingStatus)this.bucketLoggingStatus).setPredefinedAcl(GSAccessControlList.REST_CANNED_BUCKET_OWNER_READ);
                } else if (elementText.equals(GSAccessControlList.REST_CANNED_BUCKET_OWNER_FULL_CONTROL.getValueForRESTHeaderACL())) {
                    ((GSBucketLoggingStatus)this.bucketLoggingStatus).setPredefinedAcl(GSAccessControlList.REST_CANNED_BUCKET_OWNER_FULL_CONTROL);
                }
            }
        }
    }

    public class S3BucketLoggingStatusHandler
    extends BucketLoggingStatusHandler {
        private String targetBucket;
        private String targetPrefix;
        private GranteeInterface currentGrantee;
        private Permission currentPermission;

        public S3BucketLoggingStatusHandler() {
            this.targetBucket = null;
            this.targetPrefix = null;
            this.currentGrantee = null;
            this.currentPermission = null;
        }

        public void startElement(String name) {
            if (name.equals("BucketLoggingStatus")) {
                this.bucketLoggingStatus = new S3BucketLoggingStatus();
            }
        }

        public void endElement(String name, String elementText) {
            if (name.equals("TargetBucket")) {
                this.targetBucket = elementText;
            } else if (name.equals("TargetPrefix")) {
                this.targetPrefix = elementText;
            } else if (name.equals("LoggingEnabled")) {
                this.bucketLoggingStatus.setTargetBucketName(this.targetBucket);
                this.bucketLoggingStatus.setLogfilePrefix(this.targetPrefix);
            } else if (name.equals("ID")) {
                this.currentGrantee = new CanonicalGrantee();
                this.currentGrantee.setIdentifier(elementText);
            } else if (name.equals("EmailAddress")) {
                this.currentGrantee = new EmailAddressGrantee();
                this.currentGrantee.setIdentifier(elementText);
            } else if (name.equals("URI")) {
                this.currentGrantee = new GroupGrantee();
                this.currentGrantee.setIdentifier(elementText);
            } else if (name.equals("DisplayName")) {
                ((CanonicalGrantee)this.currentGrantee).setDisplayName(elementText);
            } else if (name.equals("Permission")) {
                this.currentPermission = Permission.parsePermission(elementText);
            } else if (name.equals("Grant")) {
                GrantAndPermission grantAndPermission = new GrantAndPermission(this.currentGrantee, this.currentPermission);
                ((S3BucketLoggingStatus)this.bucketLoggingStatus).addTargetGrant(grantAndPermission);
            }
        }
    }

    public class BucketLoggingStatusHandler
    extends DefaultXmlHandler {
        protected StorageBucketLoggingStatus bucketLoggingStatus;

        public StorageBucketLoggingStatus getBucketLoggingStatus() {
            return this.bucketLoggingStatus;
        }
    }

    public class ListAllMyBucketsHandler
    extends DefaultXmlHandler {
        private StorageOwner bucketsOwner = null;
        private StorageBucket currentBucket = null;
        private final List<StorageBucket> buckets = new ArrayList<StorageBucket>();

        public StorageBucket[] getBuckets() {
            return this.buckets.toArray(new StorageBucket[this.buckets.size()]);
        }

        public StorageOwner getOwner() {
            return this.bucketsOwner;
        }

        public void startElement(String name) {
            if (name.equals("Bucket")) {
                this.currentBucket = XmlResponsesSaxParser.this.newBucket();
            } else if (name.equals("Owner")) {
                this.bucketsOwner = XmlResponsesSaxParser.this.newOwner();
            }
        }

        public void endElement(String name, String elementText) {
            if (name.equals("ID")) {
                this.bucketsOwner.setId(elementText);
            } else if (name.equals("DisplayName")) {
                this.bucketsOwner.setDisplayName(elementText);
            } else if (name.equals("Bucket")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created new bucket from listing: " + this.currentBucket));
                }
                this.currentBucket.setOwner(this.bucketsOwner);
                this.buckets.add(this.currentBucket);
            } else if (name.equals("Name")) {
                this.currentBucket.setName(elementText);
            } else if (name.equals("CreationDate")) {
                elementText = elementText + ".000Z";
                try {
                    this.currentBucket.setCreationDate(ServiceUtils.parseIso8601Date(elementText));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Non-ISO8601 date for CreationDate in list buckets output: " + elementText, e);
                }
            }
        }
    }

    public class ListBucketHandler
    extends DefaultXmlHandler {
        private StorageObject currentObject = null;
        private StorageOwner currentOwner = null;
        private boolean insideCommonPrefixes = false;
        private final List<StorageObject> objects = new ArrayList<StorageObject>();
        private final List<String> commonPrefixes = new ArrayList<String>();
        private String bucketName = null;
        private String requestPrefix = null;
        private String requestMarker = null;
        private long requestMaxKeys = 0L;
        private boolean listingTruncated = false;
        private String lastKey = null;
        private String nextMarker = null;

        public String getMarkerForNextListing() {
            if (this.listingTruncated) {
                if (this.nextMarker != null) {
                    return this.nextMarker;
                }
                if (this.lastKey != null) {
                    return this.lastKey;
                }
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Unable to find Next Marker or Last Key for truncated listing");
                }
                return null;
            }
            return null;
        }

        public boolean isListingTruncated() {
            return this.listingTruncated;
        }

        public StorageObject[] getObjects() {
            return this.objects.toArray(new StorageObject[this.objects.size()]);
        }

        public String[] getCommonPrefixes() {
            return this.commonPrefixes.toArray(new String[this.commonPrefixes.size()]);
        }

        public String getRequestPrefix() {
            return this.requestPrefix;
        }

        public String getRequestMarker() {
            return this.requestMarker;
        }

        public String getNextMarker() {
            return this.nextMarker;
        }

        public long getRequestMaxKeys() {
            return this.requestMaxKeys;
        }

        public void startElement(String name) {
            if (name.equals("Contents")) {
                this.currentObject = XmlResponsesSaxParser.this.newObject();
                if (this.currentObject instanceof S3Object) {
                    ((S3Object)this.currentObject).setBucketName(this.bucketName);
                }
            } else if (name.equals("Owner")) {
                this.currentOwner = XmlResponsesSaxParser.this.newOwner();
                this.currentObject.setOwner(this.currentOwner);
            } else if (name.equals("CommonPrefixes")) {
                this.insideCommonPrefixes = true;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void endElement(String name, String elementText) {
            if (name.equals("Name")) {
                this.bucketName = elementText;
                if (!log.isDebugEnabled()) return;
                log.debug((Object)("Examining listing for bucket: " + this.bucketName));
                return;
            } else if (!this.insideCommonPrefixes && name.equals("Prefix")) {
                this.requestPrefix = elementText;
                return;
            } else if (name.equals("Marker")) {
                this.requestMarker = elementText;
                return;
            } else if (name.equals("NextMarker")) {
                this.nextMarker = elementText;
                return;
            } else if (name.equals("MaxKeys")) {
                this.requestMaxKeys = Long.parseLong(elementText);
                return;
            } else if (name.equals("IsTruncated")) {
                String isTruncatedStr = elementText.toLowerCase(Locale.getDefault());
                if (isTruncatedStr.startsWith("false")) {
                    this.listingTruncated = false;
                    return;
                } else {
                    if (!isTruncatedStr.startsWith("true")) throw new RuntimeException("Invalid value for IsTruncated field: " + isTruncatedStr);
                    this.listingTruncated = true;
                }
                return;
            } else if (name.equals("Contents")) {
                this.objects.add(this.currentObject);
                if (!log.isDebugEnabled()) return;
                log.debug((Object)("Created new object from listing: " + this.currentObject));
                return;
            } else if (name.equals("Key")) {
                this.currentObject.setKey(elementText);
                this.lastKey = elementText;
                return;
            } else if (name.equals("LastModified")) {
                try {
                    this.currentObject.setLastModifiedDate(ServiceUtils.parseIso8601Date(elementText));
                    return;
                }
                catch (ParseException e) {
                    throw new RuntimeException("Non-ISO8601 date for LastModified in bucket's object listing output: " + elementText, e);
                }
            } else if (name.equals("ETag")) {
                this.currentObject.setETag(elementText);
                return;
            } else if (name.equals("Size")) {
                this.currentObject.setContentLength(Long.parseLong(elementText));
                return;
            } else if (name.equals("StorageClass")) {
                this.currentObject.setStorageClass(elementText);
                return;
            } else if (name.equals("ID")) {
                if (this.currentOwner == null) {
                    this.currentOwner = XmlResponsesSaxParser.this.newOwner();
                    this.currentObject.setOwner(this.currentOwner);
                }
                this.currentOwner.setId(elementText);
                return;
            } else if (name.equals("DisplayName")) {
                this.currentOwner.setDisplayName(elementText);
                return;
            } else if (this.insideCommonPrefixes && name.equals("Prefix")) {
                this.commonPrefixes.add(elementText);
                return;
            } else {
                if (!name.equals("CommonPrefixes")) return;
                this.insideCommonPrefixes = false;
            }
        }
    }
}

