/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.contribs.mx;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.hadoop.hbase.shaded.contribs.mx.LongCounter;
import org.apache.hadoop.hbase.shaded.contribs.mx.S3BucketMxMBean;
import org.apache.hadoop.hbase.shaded.contribs.mx.S3ServiceMx;
import org.apache.hadoop.hbase.shaded.org.jets3t.service.model.StorageBucket;

public class S3BucketMx
implements S3BucketMxMBean {
    public static final boolean isEnabled = "true".equals(System.getProperty("jets3t.bucket.mx"));
    private static Map objects = Collections.synchronizedMap(new HashMap());
    private static final int TOTAL = 0;
    private static final int O_GET = 1;
    private static final int O_HEAD = 2;
    private static final int O_PUT = 3;
    private static final int O_DELETE = 4;
    private static final int O_COPY = 5;
    private static final int LIST = 6;
    private static final int MAX = 7;
    private final LongCounter[] counters = new LongCounter[7];

    S3BucketMx() {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = new LongCounter();
        }
    }

    public long getTotalRequests() {
        return this.counters[0].getValue();
    }

    public long getTotalListRequests() {
        return this.counters[6].getValue();
    }

    public long getTotalObjectGetRequests() {
        return this.counters[1].getValue();
    }

    public long getTotalObjectHeadRequests() {
        return this.counters[2].getValue();
    }

    public long getTotalObjectPutRequests() {
        return this.counters[3].getValue();
    }

    public long getTotalObjectDeleteRequests() {
        return this.counters[4].getValue();
    }

    public long getTotalObjectCopyRequests() {
        return this.counters[5].getValue();
    }

    public static void registerMBeans(StorageBucket[] buckets) {
        if (!isEnabled) {
            return;
        }
        for (int i = 0; i < buckets.length; ++i) {
            S3BucketMx.getInstance(buckets[i].getName());
        }
    }

    private static S3BucketMx getInstance(String bucketName) {
        String props = "Type=S3Bucket,Name=" + bucketName;
        S3BucketMx object = (S3BucketMx)objects.get(props);
        if (object == null) {
            object = new S3BucketMx();
            objects.put(props, object);
            ObjectName name = S3ServiceMx.getObjectName(props);
            try {
                S3ServiceMx.registerMBean(object, name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    private void increment(int type) {
        this.counters[0].increment();
        this.counters[type].increment();
    }

    public static void increment(int type, String bucketName) {
        if (isEnabled) {
            S3BucketMx object = S3BucketMx.getInstance(bucketName);
            object.increment(type);
        }
        S3ServiceMx.getInstance().bucketCounter.increment(type);
    }

    static void o_get(String bucketName) {
        S3BucketMx.increment(1, bucketName);
    }

    static void o_head(String bucketName) {
        S3BucketMx.increment(2, bucketName);
    }

    static void o_put(String bucketName) {
        S3BucketMx.increment(3, bucketName);
    }

    static void o_delete(String bucketName) {
        S3BucketMx.increment(4, bucketName);
    }

    static void o_copy(String bucketName) {
        S3BucketMx.increment(5, bucketName);
    }

    public static void list(String bucketName) {
        S3BucketMx.increment(6, bucketName);
    }
}

