/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.cassandra.auth.INetworkAuthorizer;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.auth.Roles;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.statements.ListRolesStatement;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ListUsersStatement
extends ListRolesStatement {
    private static final String KS = "system_auth";
    private static final String CF = "users";
    private static final List<ColumnSpecification> metadata = ImmutableList.of((Object)new ColumnSpecification("system_auth", "users", new ColumnIdentifier("name", true), UTF8Type.instance), (Object)new ColumnSpecification("system_auth", "users", new ColumnIdentifier("super", true), BooleanType.instance), (Object)new ColumnSpecification("system_auth", "users", new ColumnIdentifier("datacenters", true), UTF8Type.instance));

    @Override
    protected ResultMessage formatResults(List<RoleResource> sortedRoles) {
        ResultSet.ResultMetadata resultMetadata = new ResultSet.ResultMetadata(metadata);
        ResultSet result = new ResultSet(resultMetadata);
        IRoleManager roleManager = DatabaseDescriptor.getRoleManager();
        INetworkAuthorizer networkAuthorizer = DatabaseDescriptor.getNetworkAuthorizer();
        for (RoleResource role : sortedRoles) {
            if (!roleManager.canLogin(role)) continue;
            result.addColumnValue(UTF8Type.instance.decompose(role.getRoleName()));
            result.addColumnValue(BooleanType.instance.decompose(Roles.hasSuperuserStatus(role)));
            result.addColumnValue(UTF8Type.instance.decompose(networkAuthorizer.authorize(role).toString()));
        }
        return new ResultMessage.Rows(result);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

