/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.PercentileTracker;
import com.datastax.driver.core.Statement;

public class ClusterWidePercentileTracker
extends PercentileTracker {
    private volatile Cluster cluster;

    private ClusterWidePercentileTracker(long highestTrackableLatencyMillis, int numberOfSignificantValueDigits, int minRecordedValues, long intervalMs) {
        super(highestTrackableLatencyMillis, numberOfSignificantValueDigits, minRecordedValues, intervalMs);
    }

    @Override
    public void onRegister(Cluster cluster) {
        this.cluster = cluster;
    }

    @Override
    protected Cluster computeKey(Host host, Statement statement, Exception exception) {
        return this.cluster;
    }

    public static Builder builder(long highestTrackableLatencyMillis) {
        return new Builder(highestTrackableLatencyMillis);
    }

    public static class Builder
    extends PercentileTracker.Builder<Builder, ClusterWidePercentileTracker> {
        Builder(long highestTrackableLatencyMillis) {
            super(highestTrackableLatencyMillis);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterWidePercentileTracker build() {
            return new ClusterWidePercentileTracker(this.highestTrackableLatencyMillis, this.numberOfSignificantValueDigits, this.minRecordedValues, this.intervalMs);
        }
    }
}

