/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.core;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.FSMCaller;
import com.alipay.sofa.jraft.Lifecycle;
import com.alipay.sofa.jraft.closure.ClosureQueue;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.Ballot;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.BallotBoxOptions;
import com.alipay.sofa.jraft.util.Describer;
import com.alipay.sofa.jraft.util.OnlyForTest;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.SegmentList;
import java.util.concurrent.locks.StampedLock;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BallotBox
implements Lifecycle<BallotBoxOptions>,
Describer {
    private static final Logger LOG = LoggerFactory.getLogger(BallotBox.class);
    private FSMCaller waiter;
    private ClosureQueue closureQueue;
    private final StampedLock stampedLock = new StampedLock();
    private long lastCommittedIndex = 0L;
    private long pendingIndex;
    private final SegmentList<Ballot> pendingMetaQueue = new SegmentList(false);

    @OnlyForTest
    long getPendingIndex() {
        return this.pendingIndex;
    }

    @OnlyForTest
    SegmentList<Ballot> getPendingMetaQueue() {
        return this.pendingMetaQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastCommittedIndex() {
        long stamp = this.stampedLock.tryOptimisticRead();
        long optimisticVal = this.lastCommittedIndex;
        if (this.stampedLock.validate(stamp)) {
            return optimisticVal;
        }
        stamp = this.stampedLock.readLock();
        try {
            long l = this.lastCommittedIndex;
            return l;
        }
        finally {
            this.stampedLock.unlockRead(stamp);
        }
    }

    @Override
    public boolean init(BallotBoxOptions opts) {
        if (opts.getWaiter() == null || opts.getClosureQueue() == null) {
            LOG.error("waiter or closure queue is null.");
            return false;
        }
        this.waiter = opts.getWaiter();
        this.closureQueue = opts.getClosureQueue();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitAt(long firstLogIndex, long lastLogIndex, PeerId peer) {
        long stamp = this.stampedLock.writeLock();
        long lastCommittedIndex = 0L;
        try {
            if (this.pendingIndex == 0L) {
                boolean bl = false;
                return bl;
            }
            if (lastLogIndex < this.pendingIndex) {
                boolean bl = true;
                return bl;
            }
            if (lastLogIndex >= this.pendingIndex + (long)this.pendingMetaQueue.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            long startAt = Math.max(this.pendingIndex, firstLogIndex);
            Ballot.PosHint hint = new Ballot.PosHint();
            for (long logIndex = startAt; logIndex <= lastLogIndex; ++logIndex) {
                Ballot bl = this.pendingMetaQueue.get((int)(logIndex - this.pendingIndex));
                hint = bl.grant(peer, hint);
                if (!bl.isGranted()) continue;
                lastCommittedIndex = logIndex;
            }
            if (lastCommittedIndex == 0L) {
                boolean bl = true;
                return bl;
            }
            this.pendingMetaQueue.removeFromFirst((int)(lastCommittedIndex - this.pendingIndex) + 1);
            LOG.debug("Committed log fromIndex={}, toIndex={}.", (Object)this.pendingIndex, (Object)lastCommittedIndex);
            this.pendingIndex = lastCommittedIndex + 1L;
            this.lastCommittedIndex = lastCommittedIndex;
        }
        finally {
            this.stampedLock.unlockWrite(stamp);
        }
        this.waiter.onCommitted(lastCommittedIndex);
        return true;
    }

    public void clearPendingTasks() {
        long stamp = this.stampedLock.writeLock();
        try {
            this.pendingMetaQueue.clear();
            this.pendingIndex = 0L;
            this.closureQueue.clear();
        }
        finally {
            this.stampedLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetPendingIndex(long newPendingIndex) {
        long stamp = this.stampedLock.writeLock();
        try {
            if (this.pendingIndex != 0L || !this.pendingMetaQueue.isEmpty()) {
                LOG.error("resetPendingIndex fail, pendingIndex={}, pendingMetaQueueSize={}.", (Object)this.pendingIndex, (Object)this.pendingMetaQueue.size());
                boolean bl = false;
                return bl;
            }
            if (newPendingIndex <= this.lastCommittedIndex) {
                LOG.error("resetPendingIndex fail, newPendingIndex={}, lastCommittedIndex={}.", (Object)newPendingIndex, (Object)this.lastCommittedIndex);
                boolean bl = false;
                return bl;
            }
            this.pendingIndex = newPendingIndex;
            this.closureQueue.resetFirstIndex(newPendingIndex);
            boolean bl = true;
            return bl;
        }
        finally {
            this.stampedLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appendPendingTask(Configuration conf, Configuration oldConf, Closure done) {
        Ballot bl = new Ballot();
        if (!bl.init(conf, oldConf)) {
            LOG.error("Fail to init ballot.");
            return false;
        }
        long stamp = this.stampedLock.writeLock();
        try {
            if (this.pendingIndex <= 0L) {
                LOG.error("Fail to appendingTask, pendingIndex={}.", (Object)this.pendingIndex);
                boolean bl2 = false;
                return bl2;
            }
            this.pendingMetaQueue.add(bl);
            this.closureQueue.appendPendingClosure(done);
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.stampedLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setLastCommittedIndex(long lastCommittedIndex) {
        boolean doUnlock = true;
        long stamp = this.stampedLock.writeLock();
        try {
            if (this.pendingIndex != 0L || !this.pendingMetaQueue.isEmpty()) {
                Requires.requireTrue(lastCommittedIndex < this.pendingIndex, "Node changes to leader, pendingIndex=%d, param lastCommittedIndex=%d", this.pendingIndex, lastCommittedIndex);
                boolean bl = false;
                return bl;
            }
            if (lastCommittedIndex < this.lastCommittedIndex) {
                boolean bl = false;
                return bl;
            }
            if (lastCommittedIndex > this.lastCommittedIndex) {
                this.lastCommittedIndex = lastCommittedIndex;
                this.stampedLock.unlockWrite(stamp);
                doUnlock = false;
                this.waiter.onCommitted(lastCommittedIndex);
            }
        }
        finally {
            if (doUnlock) {
                this.stampedLock.unlockWrite(stamp);
            }
        }
        return true;
    }

    @Override
    public void shutdown() {
        this.clearPendingTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void describe(Describer.Printer out) {
        long _pendingMetaQueueSize;
        long _pendingIndex;
        long _lastCommittedIndex;
        long stamp = this.stampedLock.tryOptimisticRead();
        if (this.stampedLock.validate(stamp)) {
            _lastCommittedIndex = this.lastCommittedIndex;
            _pendingIndex = this.pendingIndex;
            _pendingMetaQueueSize = this.pendingMetaQueue.size();
        } else {
            stamp = this.stampedLock.readLock();
            try {
                _lastCommittedIndex = this.lastCommittedIndex;
                _pendingIndex = this.pendingIndex;
                _pendingMetaQueueSize = this.pendingMetaQueue.size();
            }
            finally {
                this.stampedLock.unlockRead(stamp);
            }
        }
        out.print("  lastCommittedIndex: ").println(_lastCommittedIndex);
        out.print("  pendingIndex: ").println(_pendingIndex);
        out.print("  pendingMetaQueueSize: ").println(_pendingMetaQueueSize);
    }
}

