/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.hbase;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.page.PageState;
import org.apache.hugegraph.backend.query.Aggregate;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.IdPrefixQuery;
import org.apache.hugegraph.backend.query.IdRangeQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.serializer.BinaryBackendEntry;
import org.apache.hugegraph.backend.serializer.BinaryEntryIterator;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendEntryIterator;
import org.apache.hugegraph.backend.store.BackendTable;
import org.apache.hugegraph.backend.store.Shard;
import org.apache.hugegraph.backend.store.hbase.HbaseSessions;
import org.apache.hugegraph.backend.store.hbase.HbaseStore;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.StringEncoding;
import org.slf4j.Logger;

public class HbaseTable
extends BackendTable<HbaseSessions.Session, BackendEntry> {
    private static final Logger LOG = Log.logger(HbaseStore.class);
    protected static final byte[] CF = "f".getBytes();
    private final HbaseShardSplitter shardSplitter;
    private final boolean enablePartition;

    public HbaseTable(String table, boolean enablePartition) {
        super(table);
        this.enablePartition = enablePartition;
        this.shardSplitter = new HbaseShardSplitter(this.table());
    }

    public HbaseTable(String table) {
        this(table, false);
    }

    public static List<byte[]> cfs() {
        return ImmutableList.of((Object)CF);
    }

    protected void registerMetaHandlers() {
        this.registerMetaHandler("splits", (session, meta, args) -> {
            E.checkArgument((args.length == 1 ? 1 : 0) != 0, (String)"The args count of %s must be 1", (Object[])new Object[]{meta});
            long splitSize = (Long)args[0];
            return this.shardSplitter.getSplits((HbaseSessions.Session)session, splitSize);
        });
    }

    public void init(HbaseSessions.Session session) {
    }

    public void clear(HbaseSessions.Session session) {
    }

    public void insert(HbaseSessions.Session session, BackendEntry entry) {
        assert (!entry.columns().isEmpty());
        session.put(this.table(), CF, entry.id().asBytes(), entry.columns());
    }

    public void delete(HbaseSessions.Session session, BackendEntry entry) {
        if (entry.columns().isEmpty()) {
            session.delete(this.table(), CF, entry.id().asBytes());
        } else {
            for (BackendEntry.BackendColumn col : entry.columns()) {
                session.remove(this.table(), CF, entry.id().asBytes(), col.name);
            }
        }
    }

    public void append(HbaseSessions.Session session, BackendEntry entry) {
        assert (entry.columns().size() == 1);
        this.insert(session, entry);
    }

    public void eliminate(HbaseSessions.Session session, BackendEntry entry) {
        assert (entry.columns().size() == 1);
        this.delete(session, entry);
    }

    public boolean queryExist(HbaseSessions.Session session, BackendEntry entry) {
        Id id = entry.id();
        try (HbaseSessions.RowIterator iter = this.queryById(session, id);){
            boolean bl = iter.hasNext();
            return bl;
        }
    }

    public Number queryNumber(HbaseSessions.Session session, Query query) {
        Number number;
        block10: {
            Aggregate aggregate = query.aggregateNotNull();
            if (aggregate.func() != Aggregate.AggregateFunc.COUNT) {
                throw new NotSupportException(aggregate.toString());
            }
            assert (aggregate.func() == Aggregate.AggregateFunc.COUNT);
            HbaseSessions.CountSession countSession = session.countSession();
            try {
                number = this.query(countSession, query);
                if (countSession == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (countSession != null) {
                        try {
                            countSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new BackendException((Throwable)e);
                }
            }
            countSession.close();
        }
        return number;
    }

    public Iterator<BackendEntry> query(HbaseSessions.Session session, Query query) {
        if (query.limit() == 0L && !query.noLimit()) {
            LOG.debug("Return empty result(limit=0) for query {}", (Object)query);
            return Collections.emptyIterator();
        }
        HbaseSessions.Session hbaseSession = session;
        return this.newEntryIterator(query, this.query((HbaseSessions.HbaseSession)hbaseSession, query));
    }

    protected <R> R query(HbaseSessions.HbaseSession<R> session, Query query) {
        if (query.empty()) {
            return this.queryAll(session, query);
        }
        if (query instanceof IdPrefixQuery) {
            IdPrefixQuery pq = (IdPrefixQuery)query;
            return this.queryByPrefix(session, pq);
        }
        if (query instanceof IdRangeQuery) {
            IdRangeQuery rq = (IdRangeQuery)query;
            return this.queryByRange(session, rq);
        }
        if (query.conditionsSize() == 0) {
            assert (query.idsSize() > 0);
            if (query.idsSize() == 1) {
                Id id = (Id)query.ids().iterator().next();
                return this.queryById(session, id);
            }
            return this.queryByIds(session, query.ids());
        }
        ConditionQuery cq = (ConditionQuery)query;
        return this.queryByCond(session, cq);
    }

    protected <R> R queryAll(HbaseSessions.HbaseSession<R> session, Query query) {
        if (query.paging()) {
            PageState page = PageState.fromString((String)query.page());
            byte[] begin = page.position();
            return session.scan(this.table(), begin, null);
        }
        return session.scan(this.table(), -1L);
    }

    protected <R> R queryById(HbaseSessions.HbaseSession<R> session, Id id) {
        return session.get(this.table(), null, id.asBytes());
    }

    protected <R> R queryByIds(HbaseSessions.HbaseSession<R> session, Collection<Id> ids) {
        Set rowkeys = InsertionOrderUtil.newSet();
        for (Id id : ids) {
            rowkeys.add(id.asBytes());
        }
        return session.get(this.table(), null, rowkeys);
    }

    protected <R> R queryByPrefix(HbaseSessions.HbaseSession<R> session, IdPrefixQuery query) {
        return session.scan(this.table(), query.start().asBytes(), query.inclusiveStart(), query.prefix().asBytes());
    }

    protected <R> R queryByRange(HbaseSessions.HbaseSession<R> session, IdRangeQuery query) {
        byte[] start = query.start().asBytes();
        byte[] end = query.end() == null ? null : query.end().asBytes();
        return session.scan(this.table(), start, query.inclusiveStart(), end, query.inclusiveEnd());
    }

    protected <R> R queryByCond(HbaseSessions.HbaseSession<R> session, ConditionQuery query) {
        if (query.containsScanRelation()) {
            E.checkArgument((query.relations().size() == 1 ? 1 : 0) != 0, (String)"Invalid scan with multi conditions: %s", (Object[])new Object[]{query});
            Condition.Relation scan = (Condition.Relation)query.relations().iterator().next();
            Shard shard = (Shard)scan.value();
            return this.queryByRange(session, shard, query.page());
        }
        throw new NotSupportException("query: %s", new Object[]{query});
    }

    protected <R> R queryByRange(HbaseSessions.HbaseSession<R> session, Shard shard, String page) {
        byte[] start = this.shardSplitter.position(shard.start());
        byte[] end = this.shardSplitter.position(shard.end());
        if (page != null && !page.isEmpty()) {
            byte[] position = PageState.fromString((String)page).position();
            E.checkArgument((start == null || Bytes.compare((byte[])position, (byte[])start) >= 0 ? 1 : 0) != 0, (String)"Invalid page out of lower bound", (Object[])new Object[0]);
            start = position;
        }
        return session.scan(this.table(), start, end);
    }

    protected BackendEntryIterator newEntryIterator(Query query, HbaseSessions.RowIterator rows) {
        return new BinaryEntryIterator((BackendEntry.BackendIterator)rows, query, (entry, row) -> {
            E.checkState((!row.isEmpty() ? 1 : 0) != 0, (String)"Can't parse empty HBase result", (Object[])new Object[0]);
            byte[] id = row.getRow();
            if (entry == null || !Bytes.prefixWith((byte[])id, (byte[])entry.id().asBytes())) {
                HugeType type = query.resultType();
                entry = new BinaryBackendEntry(type, id, this.enablePartition);
            }
            try {
                this.parseRowColumns((Result)row, (BackendEntry)entry, query, this.enablePartition);
            }
            catch (IOException e) {
                throw new BackendException("Failed to read HBase columns", (Throwable)e);
            }
            return entry;
        });
    }

    protected void parseRowColumns(Result row, BackendEntry entry, Query query, boolean enablePartition) throws IOException {
        CellScanner cellScanner = row.cellScanner();
        while (cellScanner.advance()) {
            Cell cell = cellScanner.current();
            entry.columns(BackendEntry.BackendColumn.of((byte[])CellUtil.cloneQualifier((Cell)cell), (byte[])CellUtil.cloneValue((Cell)cell)));
        }
    }

    private static class HbaseShardSplitter
    extends BackendTable.ShardSplitter<HbaseSessions.Session> {
        public HbaseShardSplitter(String table) {
            super(table);
        }

        public List<Shard> getSplits(HbaseSessions.Session session, long splitSize) {
            E.checkArgument((splitSize >= 0x100000L ? 1 : 0) != 0, (String)"The split-size must be >= %s bytes, but got %s", (Object[])new Object[]{0x100000, splitSize});
            ArrayList<Shard> shards = new ArrayList<Shard>();
            String namespace = session.namespace();
            String table = this.table();
            Map<String, Double> regionSizes = HbaseShardSplitter.regionSizes(session, namespace, table);
            Map<String, BackendTable.ShardSplitter.Range> regionRanges = HbaseShardSplitter.regionRanges(session, namespace, table);
            for (Map.Entry<String, Double> rs : regionSizes.entrySet()) {
                String region = rs.getKey();
                double size = rs.getValue();
                BackendTable.ShardSplitter.Range range = regionRanges.get(region);
                int count = HbaseShardSplitter.calcSplitCount(size, splitSize);
                shards.addAll(range.splitEven(count));
            }
            return shards;
        }

        private static Map<String, Double> regionSizes(HbaseSessions.Session session, String namespace, String table) {
            HashMap<String, Double> regionSizes = new HashMap<String, Double>();
            try (Admin admin = session.hbase().getAdmin();){
                TableName tableName = TableName.valueOf((String)namespace, (String)table);
                for (ServerName serverName : admin.getRegionServers()) {
                    List metrics = admin.getRegionMetrics(serverName, tableName);
                    for (RegionMetrics metric : metrics) {
                        double size = metric.getStoreFileSize().get(Size.Unit.BYTE);
                        regionSizes.put(metric.getNameAsString(), size += metric.getMemStoreSize().get(Size.Unit.BYTE));
                    }
                }
            }
            catch (Throwable e) {
                throw new BackendException(String.format("Failed to get region sizes of %s(%s)", table, namespace), e);
            }
            return regionSizes;
        }

        private static Map<String, BackendTable.ShardSplitter.Range> regionRanges(HbaseSessions.Session session, String namespace, String table) {
            Map regionRanges = InsertionOrderUtil.newMap();
            TableName tableName = TableName.valueOf((String)namespace, (String)table);
            try (Admin admin = session.hbase().getAdmin();){
                for (RegionInfo regionInfo : admin.getRegions(tableName)) {
                    byte[] start = regionInfo.getStartKey();
                    byte[] end = regionInfo.getEndKey();
                    regionRanges.put(regionInfo.getRegionNameAsString(), new BackendTable.ShardSplitter.Range(start, end));
                }
            }
            catch (Throwable e) {
                throw new BackendException(String.format("Failed to get region ranges of %s(%s)", table, namespace), e);
            }
            return regionRanges;
        }

        private static int calcSplitCount(double totalSize, long splitSize) {
            return (int)Math.ceil(totalSize / (double)splitSize);
        }

        public byte[] position(String position) {
            if ("".equals(position) || "".equals(position)) {
                return null;
            }
            return StringEncoding.decodeBase64((String)position);
        }

        public long estimateDataSize(HbaseSessions.Session session) {
            try {
                return session.storeSize(this.table());
            }
            catch (IOException ignored) {
                return -1L;
            }
        }

        public long estimateNumKeys(HbaseSessions.Session session) {
            return 100000L;
        }
    }
}

