/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalRing;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class ProjectStep<S, E>
extends ScalarMapStep<S, Map<String, E>>
implements TraversalParent,
ByModulating {
    private final List<String> projectKeys;
    private TraversalRing<S, E> traversalRing;

    public ProjectStep(Traversal.Admin traversal, String ... projectKeys) {
        super(traversal);
        this.projectKeys = Arrays.asList(projectKeys);
        this.traversalRing = new TraversalRing(new Traversal.Admin[0]);
    }

    @Override
    protected Map<String, E> map(Traverser.Admin<S> traverser) {
        LinkedHashMap<String, E> end = new LinkedHashMap<String, E>(this.projectKeys.size(), 1.0f);
        for (String projectKey : this.projectKeys) {
            end.put(projectKey, TraversalUtil.applyNullable(traverser, this.traversalRing.next()));
        }
        this.traversalRing.reset();
        return end;
    }

    @Override
    public void reset() {
        super.reset();
        this.traversalRing.reset();
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.projectKeys, this.traversalRing);
    }

    @Override
    public ProjectStep<S, E> clone() {
        ProjectStep clone = (ProjectStep)super.clone();
        clone.traversalRing = this.traversalRing.clone();
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.traversalRing.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.traversalRing.hashCode() ^ this.projectKeys.hashCode();
    }

    @Override
    public List<Traversal.Admin<S, E>> getLocalChildren() {
        return this.traversalRing.getTraversals();
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> selectTraversal) {
        this.traversalRing.addTraversal(this.integrateChild(selectTraversal));
    }

    @Override
    public void replaceLocalChild(Traversal.Admin<?, ?> oldTraversal, Traversal.Admin<?, ?> newTraversal) {
        this.traversalRing.replaceTraversal(oldTraversal, newTraversal);
    }

    public List<String> getProjectKeys() {
        return this.projectKeys;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(new TraverserRequirement[0]);
    }
}

