/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.lambda;

import java.util.Map;
import java.util.Objects;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.AbstractLambdaTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Element;

public final class ValueTraversal<T, V>
extends AbstractLambdaTraversal<T, V> {
    private final String propertyKey;
    private V value;

    public ValueTraversal(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    @Override
    public V next() {
        return this.value;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addStart(Traverser.Admin<T> start) {
        if (null == this.bypassTraversal) {
            Object o = start.get();
            if (o instanceof Element) {
                this.value = ((Element)o).property(this.propertyKey).orElse(null);
                return;
            } else {
                if (!(o instanceof Map)) throw new IllegalStateException(String.format("The by(\"%s\") modulator can only be applied to a traverser that is an Element or a Map - it is being applied to [%s] a %s class instead", this.propertyKey, o, o.getClass().getSimpleName()));
                this.value = ((Map)o).get(this.propertyKey);
            }
            return;
        } else {
            this.value = TraversalUtil.apply(start, this.bypassTraversal);
        }
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public String toString() {
        return "value(" + (null == this.bypassTraversal ? this.propertyKey : this.bypassTraversal) + ')';
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.propertyKey.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueTraversal && Objects.equals(((ValueTraversal)other).propertyKey, this.propertyKey);
    }
}

