/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc;

import com.alipay.sofa.jraft.Status;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hugegraph.store.grpc.common.ResCode;
import org.apache.hugegraph.store.grpc.common.ResStatus;
import org.apache.hugegraph.store.grpc.session.FeedbackRes;
import org.apache.hugegraph.store.grpc.session.PartitionFaultResponse;
import org.apache.hugegraph.store.grpc.session.PartitionFaultType;
import org.apache.hugegraph.store.grpc.session.PartitionLeader;
import org.apache.hugegraph.store.node.grpc.BatchGrpcClosure;
import org.apache.hugegraph.store.raft.RaftClosure;
import org.apache.hugegraph.store.util.HgRaftError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchGrpcClosure<V> {
    private static final Logger log = LoggerFactory.getLogger(BatchGrpcClosure.class);
    private final CountDownLatch countDownLatch;
    private final List<Status> errorStatus;
    private final List<V> results;
    private final Map<Integer, Long> leaderMap;

    public BatchGrpcClosure(int count) {
        this.countDownLatch = new CountDownLatch(count);
        this.errorStatus = Collections.synchronizedList(new ArrayList());
        this.results = Collections.synchronizedList(new ArrayList());
        this.leaderMap = new ConcurrentHashMap();
    }

    public RaftClosure newRaftClosure() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public RaftClosure newRaftClosure(Consumer<Status> ok) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public RaftClosure newClosureNoLatch() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public PartitionFaultResponse getErrorResponse() {
        PartitionFaultResponse errorResponse;
        if (this.leaderMap.size() > 0) {
            PartitionFaultResponse.Builder partitionFault = PartitionFaultResponse.newBuilder().setFaultType(PartitionFaultType.PARTITION_FAULT_TYPE_NOT_LEADER);
            this.leaderMap.forEach((k, v) -> partitionFault.addPartitionLeaders(PartitionLeader.newBuilder().setPartitionId(k.intValue()).setLeaderId(v.longValue()).build()));
            errorResponse = partitionFault.build();
        } else {
            PartitionFaultType faultType = PartitionFaultType.PARTITION_FAULT_TYPE_UNKNOWN;
            switch (4.$SwitchMap$org$apache$hugegraph$store$util$HgRaftError[HgRaftError.forNumber((int)((Status)this.errorStatus.get(0)).getCode()).ordinal()]) {
                case 1: {
                    faultType = PartitionFaultType.PARTITION_FAULT_TYPE_NOT_LEADER;
                    break;
                }
                case 2: {
                    faultType = PartitionFaultType.PARTITION_FAULT_TYPE_WAIT_LEADER_TIMEOUT;
                    break;
                }
                case 3: {
                    faultType = PartitionFaultType.PARTITION_FAULT_TYPE_NOT_LOCAL;
                    break;
                }
                default: {
                    log.error("Unmatchable errorStatus: " + this.errorStatus);
                }
            }
            errorResponse = PartitionFaultResponse.newBuilder().setFaultType(faultType).build();
        }
        return errorResponse;
    }

    public String getErrorMsg() {
        StringBuilder builder = new StringBuilder();
        this.errorStatus.forEach(status -> {
            if (!status.isOk()) {
                builder.append(status.getErrorMsg());
                builder.append("\n");
            }
        });
        return builder.toString();
    }

    public void waitFinish(StreamObserver<V> observer, Function<List<V>, V> ok, long timeout) {
        try {
            this.countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            if (this.errorStatus.isEmpty()) {
                observer.onNext(ok.apply(this.results));
            } else {
                observer.onNext((Object)FeedbackRes.newBuilder().setStatus(ResStatus.newBuilder().setCode(ResCode.RES_CODE_FAIL).setMsg(this.getErrorMsg())).setPartitionFaultResponse(this.getErrorResponse()).build());
            }
        }
        catch (InterruptedException e) {
            log.error("waitFinish exception: ", (Throwable)e);
            observer.onNext((Object)FeedbackRes.newBuilder().setStatus(ResStatus.newBuilder().setCode(ResCode.RES_CODE_FAIL).setMsg(e.getLocalizedMessage()).build()).build());
        }
        observer.onCompleted();
    }

    public FeedbackRes selectError(List<FeedbackRes> results) {
        if (!CollectionUtils.isEmpty(results)) {
            AtomicReference<FeedbackRes> res = new AtomicReference<FeedbackRes>(results.get(0));
            results.forEach(e -> {
                try {
                    if (e.getStatus().getCode() != ResCode.RES_CODE_OK) {
                        res.set((FeedbackRes)e);
                    }
                }
                catch (Exception ex) {
                    log.error("{}", (Throwable)ex);
                }
            });
            return res.get();
        }
        return FeedbackRes.newBuilder().setStatus(ResStatus.newBuilder().setCode(ResCode.RES_CODE_OK).build()).build();
    }
}

