/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.schema;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.schema.SchemaLabel;
import org.apache.hugegraph.schema.Userdata;
import org.apache.hugegraph.schema.builder.SchemaBuilder;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.EdgeLabelType;
import org.apache.hugegraph.type.define.Frequency;
import org.apache.hugegraph.type.define.SchemaStatus;
import org.apache.hugegraph.util.E;

public class EdgeLabel
extends SchemaLabel {
    public static final EdgeLabel NONE = new EdgeLabel(null, NONE_ID, "~undefined");
    private Set<Pair<Id, Id>> links = new HashSet<Pair<Id, Id>>();
    private Id sourceLabel = NONE_ID;
    private Id targetLabel = NONE_ID;
    private Frequency frequency;
    private List<Id> sortKeys;
    private EdgeLabelType edgeLabelType = EdgeLabelType.NORMAL;
    private Id fatherId;

    public EdgeLabel(HugeGraph graph, Id id, String name) {
        super(graph, id, name);
        this.frequency = Frequency.DEFAULT;
        this.sortKeys = new ArrayList<Id>();
    }

    @Override
    public HugeType type() {
        return HugeType.EDGE_LABEL;
    }

    public boolean isFather() {
        return this.edgeLabelType.parent();
    }

    public void edgeLabelType(EdgeLabelType type) {
        this.edgeLabelType = type;
    }

    public EdgeLabelType edgeLabelType() {
        return this.edgeLabelType;
    }

    public boolean hasFather() {
        return this.edgeLabelType.sub();
    }

    public Id fatherId() {
        return this.fatherId;
    }

    public void fatherId(Id fatherId) {
        this.fatherId = fatherId;
    }

    public Frequency frequency() {
        return this.frequency;
    }

    public void frequency(Frequency frequency) {
        this.frequency = frequency;
    }

    public boolean directed() {
        return true;
    }

    public String sourceLabelName() {
        E.checkState((this.links.size() == 1 ? 1 : 0) != 0, (String)"Only edge label has single vertex label pair can call sourceLabelName(), but current edge label got %s", (Object[])new Object[]{this.links.size()});
        return this.graph.vertexLabelOrNone((Id)this.links.iterator().next().getLeft()).name();
    }

    public List<Id> linksIds() {
        ArrayList<Id> ids = new ArrayList<Id>(this.links.size() * 2);
        for (Pair<Id, Id> link : this.links) {
            ids.add((Id)link.getLeft());
            ids.add((Id)link.getRight());
        }
        return ids;
    }

    public void linksIds(Id[] ids) {
        this.links = new HashSet<Pair<Id, Id>>(ids.length / 2);
        for (int i = 0; i < ids.length; i += 2) {
            this.links.add((Pair<Id, Id>)Pair.of((Object)ids[i], (Object)ids[i + 1]));
        }
    }

    public Id sourceLabel() {
        if (this.links.size() == 1) {
            return (Id)this.links.iterator().next().getLeft();
        }
        return NONE_ID;
    }

    public void sourceLabel(Id id) {
        E.checkArgument((boolean)this.links.isEmpty(), (String)"Not allowed add source label to an edge label which already has links", (Object[])new Object[0]);
        if (this.targetLabel != NONE_ID) {
            this.links.add((Pair<Id, Id>)Pair.of((Object)id, (Object)this.targetLabel));
            this.targetLabel = NONE_ID;
        } else {
            this.sourceLabel = id;
        }
    }

    public String targetLabelName() {
        E.checkState((this.links.size() == 1 ? 1 : 0) != 0, (String)"Only edge label has single vertex label pair can call sourceLabelName(), but current edge label got %s", (Object[])new Object[]{this.links.size()});
        return this.graph.vertexLabelOrNone((Id)this.links.iterator().next().getRight()).name();
    }

    public Id targetLabel() {
        if (this.links.size() == 1) {
            return (Id)this.links.iterator().next().getRight();
        }
        return NONE_ID;
    }

    public void targetLabel(Id id) {
        E.checkArgument((boolean)this.links.isEmpty(), (String)"Not allowed add source label to an edge label which already has links", (Object[])new Object[0]);
        if (this.sourceLabel != NONE_ID) {
            this.links.add((Pair<Id, Id>)Pair.of((Object)this.sourceLabel, (Object)id));
            this.sourceLabel = NONE_ID;
        } else {
            this.targetLabel = id;
        }
    }

    public boolean linkWithLabel(Id id) {
        for (Pair<Id, Id> link : this.links) {
            if (!((Id)link.getLeft()).equals(id) && !((Id)link.getRight()).equals(id)) continue;
            return true;
        }
        return false;
    }

    public boolean linkWithVertexLabel(Id label, Directions dir) {
        return this.links.stream().anyMatch(pair -> {
            Id sourceLabel = (Id)pair.getLeft();
            Id targetLabel = (Id)pair.getRight();
            if (dir.equals(Directions.IN)) {
                return targetLabel.equals(label);
            }
            if (dir.equals(Directions.OUT)) {
                return sourceLabel.equals(label);
            }
            if (dir.equals(Directions.BOTH)) {
                return targetLabel.equals(label) || sourceLabel.equals(label);
            }
            return false;
        });
    }

    public boolean checkLinkEqual(Id sourceLabel, Id targetLabel) {
        return this.links.contains(Pair.of((Object)sourceLabel, (Object)targetLabel));
    }

    public Set<Pair<Id, Id>> links() {
        return this.links;
    }

    public void links(Pair<Id, Id> link) {
        if (this.links == null) {
            this.links = new HashSet<Pair<Id, Id>>();
        }
        this.links.add(link);
    }

    public boolean existSortKeys() {
        return !this.sortKeys.isEmpty();
    }

    public List<Id> sortKeys() {
        return Collections.unmodifiableList(this.sortKeys);
    }

    public void sortKey(Id id) {
        this.sortKeys.add(id);
    }

    public void sortKeys(Id ... ids) {
        this.sortKeys.addAll(Arrays.asList(ids));
    }

    public boolean hasSameContent(EdgeLabel other) {
        return super.hasSameContent(other) && this.frequency == other.frequency && Objects.equal((Object)this.sourceLabelName(), (Object)other.sourceLabelName()) && Objects.equal((Object)this.targetLabelName(), (Object)other.targetLabelName()) && Objects.equal(this.graph.mapPkId2Name(this.sortKeys), other.graph.mapPkId2Name(other.sortKeys));
    }

    public static EdgeLabel undefined(HugeGraph graph, Id id) {
        return new EdgeLabel(graph, id, "~undefined");
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.sourceLabel() != null && this.sourceLabel() != NONE_ID) {
            map.put("sourceLabel", this.sourceLabel().asString());
        }
        if (this.targetLabel() != null && this.targetLabel() != NONE_ID) {
            map.put("targetLabel", this.targetLabel().asString());
        }
        if (this.properties() != null) {
            map.put("properties", this.properties());
        }
        if (this.nullableKeys() != null) {
            map.put("nullableKeys", this.nullableKeys());
        }
        if (this.indexLabels() != null) {
            map.put("indexLabels", this.indexLabels());
        }
        if (this.ttlStartTime() != null) {
            map.put("ttlStartTime", this.ttlStartTime().asString());
        }
        if (this.sortKeys() != null) {
            map.put("sortKeys", this.sortKeys);
        }
        map.put("edgeLabelType", this.edgeLabelType);
        if (this.fatherId() != null) {
            map.put("fatherId", this.fatherId().asString());
        }
        map.put("enableLabelIndex", this.enableLabelIndex());
        map.put("ttl", String.valueOf(this.ttl()));
        map.put("links", this.links());
        map.put("frequency", this.frequency().toString());
        return super.asMap(map);
    }

    public static EdgeLabel fromMap(Map<String, Object> map, HugeGraph graph) {
        Id id = IdGenerator.of(((Integer)map.get("id")).intValue());
        String name = (String)map.get("name");
        EdgeLabel edgeLabel = new EdgeLabel(graph, id, name);
        block37: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "id": 
                case "name": {
                    break;
                }
                case "status": {
                    edgeLabel.status(SchemaStatus.valueOf(((String)entry.getValue()).toUpperCase()));
                    break;
                }
                case "userdata": {
                    edgeLabel.userdata(new Userdata((Map)entry.getValue()));
                    break;
                }
                case "properties": {
                    Set<Id> ids = ((List)entry.getValue()).stream().map(IdGenerator::of).collect(Collectors.toSet());
                    edgeLabel.properties(ids);
                    break;
                }
                case "nullableKeys": {
                    Set<Id> ids = ((List)entry.getValue()).stream().map(IdGenerator::of).collect(Collectors.toSet());
                    edgeLabel.nullableKeys(ids);
                    break;
                }
                case "indexLabels": {
                    Set<Id> ids = ((List)entry.getValue()).stream().map(IdGenerator::of).collect(Collectors.toSet());
                    edgeLabel.addIndexLabels(ids.toArray(new Id[0]));
                    break;
                }
                case "enableLabelIndex": {
                    boolean enableLabelIndex = (Boolean)entry.getValue();
                    edgeLabel.enableLabelIndex(enableLabelIndex);
                    break;
                }
                case "ttl": {
                    long ttl = Long.parseLong((String)entry.getValue());
                    edgeLabel.ttl(ttl);
                    break;
                }
                case "ttlStartTime": {
                    long ttlStartTime = Long.parseLong((String)entry.getValue());
                    edgeLabel.ttlStartTime(IdGenerator.of(ttlStartTime));
                    break;
                }
                case "links": {
                    List list = (List)entry.getValue();
                    for (Map m : list) {
                        for (Object key : m.keySet()) {
                            Id sid = IdGenerator.of(Long.parseLong((String)key));
                            Id tid = IdGenerator.of(Long.parseLong(String.valueOf(m.get(key))));
                            edgeLabel.links((Pair<Id, Id>)Pair.of((Object)sid, (Object)tid));
                        }
                    }
                    continue block37;
                }
                case "sourceLabel": {
                    long sourceLabel = Long.parseLong((String)entry.getValue());
                    edgeLabel.sourceLabel(IdGenerator.of(sourceLabel));
                    break;
                }
                case "targetLabel": {
                    long targetLabel = Long.parseLong((String)entry.getValue());
                    edgeLabel.targetLabel(IdGenerator.of(targetLabel));
                    break;
                }
                case "fatherId": {
                    long fatherId = Long.parseLong((String)entry.getValue());
                    edgeLabel.fatherId(IdGenerator.of(fatherId));
                    break;
                }
                case "edgeLabelType": {
                    EdgeLabelType edgeLabelType = EdgeLabelType.valueOf(((String)entry.getValue()).toUpperCase());
                    edgeLabel.edgeLabelType(edgeLabelType);
                    break;
                }
                case "frequency": {
                    Frequency frequency = Frequency.valueOf(((String)entry.getValue()).toUpperCase());
                    edgeLabel.frequency(frequency);
                    break;
                }
                case "sortKeys": {
                    Set<Id> ids = ((List)entry.getValue()).stream().map(IdGenerator::of).collect(Collectors.toSet());
                    edgeLabel.sortKeys(ids.toArray(new Id[0]));
                    break;
                }
                default: {
                    throw new AssertionError((Object)String.format("Invalid key '%s' for edge label", entry.getKey()));
                }
            }
        }
        return edgeLabel;
    }

    public static final class P {
        public static final String ID = "id";
        public static final String NAME = "name";
        public static final String STATUS = "status";
        public static final String USERDATA = "userdata";
        public static final String PROPERTIES = "properties";
        public static final String NULLABLE_KEYS = "nullableKeys";
        public static final String INDEX_LABELS = "indexLabels";
        public static final String ENABLE_LABEL_INDEX = "enableLabelIndex";
        public static final String TTL = "ttl";
        public static final String TT_START_TIME = "ttlStartTime";
        public static final String LINKS = "links";
        public static final String SOURCE_LABEL = "sourceLabel";
        public static final String TARGET_LABEL = "targetLabel";
        public static final String EDGELABEL_TYPE = "edgeLabelType";
        public static final String FATHER_ID = "fatherId";
        public static final String FREQUENCY = "frequency";
        public static final String SORT_KEYS = "sortKeys";
    }

    public static interface Builder
    extends SchemaBuilder<EdgeLabel> {
        public Id rebuildIndex();

        public Builder asBase();

        public Builder withBase(String var1);

        public Builder link(String var1, String var2);

        @Deprecated
        public Builder sourceLabel(String var1);

        @Deprecated
        public Builder targetLabel(String var1);

        public Builder singleTime();

        public Builder multiTimes();

        public Builder sortKeys(String ... var1);

        public Builder properties(String ... var1);

        public Builder nullableKeys(String ... var1);

        public Builder frequency(Frequency var1);

        public Builder ttl(long var1);

        public Builder ttlStartTime(String var1);

        public Builder enableLabelIndex(boolean var1);

        public Builder userdata(String var1, Object var2);

        public Builder userdata(Map<String, Object> var1);
    }
}

