/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class TablePermission
extends Permission {
    private TableName table;
    private byte[] family;
    private byte[] qualifier;

    TablePermission(TableName table, byte[] family, byte[] qualifier, Permission.Action ... assigned) {
        super(assigned);
        this.table = table;
        this.family = family;
        this.qualifier = qualifier;
        this.scope = Permission.Scope.TABLE;
    }

    public TableName getTableName() {
        return this.table;
    }

    public boolean hasFamily() {
        return this.family != null;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public boolean hasQualifier() {
        return this.qualifier != null;
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    public String getNamespace() {
        return this.table.getNamespaceAsString();
    }

    public boolean implies(TableName table, byte[] family, byte[] qualifier, Permission.Action action) {
        if (this.failCheckTable(table)) {
            return false;
        }
        if (this.failCheckFamily(family)) {
            return false;
        }
        if (this.failCheckQualifier(qualifier)) {
            return false;
        }
        return this.implies(action);
    }

    public boolean implies(TableName table, byte[] family, Permission.Action action) {
        if (this.failCheckTable(table)) {
            return false;
        }
        if (this.failCheckFamily(family)) {
            return false;
        }
        return this.implies(action);
    }

    private boolean failCheckTable(TableName table) {
        return this.table == null || !this.table.equals((Object)table);
    }

    private boolean failCheckFamily(byte[] family) {
        return this.family != null && (family == null || !Bytes.equals((byte[])this.family, (byte[])family));
    }

    private boolean failCheckQualifier(byte[] qual) {
        return this.qualifier != null && (qual == null || !Bytes.equals((byte[])this.qualifier, (byte[])qual));
    }

    public boolean implies(TableName table, KeyValue kv, Permission.Action action) {
        if (this.failCheckTable(table)) {
            return false;
        }
        if (this.family != null && !CellUtil.matchingFamily((Cell)kv, (byte[])this.family)) {
            return false;
        }
        if (this.qualifier != null && !CellUtil.matchingQualifier((Cell)kv, (byte[])this.qualifier)) {
            return false;
        }
        return super.implies(action);
    }

    public boolean tableFieldsEqual(TablePermission tp) {
        if (tp == null) {
            return false;
        }
        boolean tEq = this.table == null && tp.table == null || this.table != null && this.table.equals((Object)tp.table);
        boolean fEq = this.family == null && tp.family == null || Bytes.equals((byte[])this.family, (byte[])tp.family);
        boolean qEq = this.qualifier == null && tp.qualifier == null || Bytes.equals((byte[])this.qualifier, (byte[])tp.qualifier);
        return tEq && fEq && qEq;
    }

    @Override
    public boolean equalsExceptActions(Object obj) {
        if (!(obj instanceof TablePermission)) {
            return false;
        }
        TablePermission other = (TablePermission)((Object)obj);
        return this.tableFieldsEqual(other);
    }

    @Override
    public boolean equals(Object obj) {
        return this.equalsExceptActions(obj) && super.equals(obj);
    }

    @Override
    public int hashCode() {
        int prime = 37;
        int result = super.hashCode();
        if (this.table != null) {
            result = 37 * result + this.table.hashCode();
        }
        if (this.family != null) {
            result = 37 * result + Bytes.hashCode((byte[])this.family);
        }
        if (this.qualifier != null) {
            result = 37 * result + Bytes.hashCode((byte[])this.qualifier);
        }
        return result;
    }

    @Override
    public String toString() {
        return "[TablePermission: " + this.rawExpression() + "]";
    }

    @Override
    protected String rawExpression() {
        StringBuilder raw = new StringBuilder();
        if (this.table != null) {
            raw.append("table=").append(this.table).append(", family=").append(this.family == null ? null : Bytes.toString((byte[])this.family)).append(", qualifier=").append(this.qualifier == null ? null : Bytes.toString((byte[])this.qualifier)).append(", ");
        }
        return raw.toString() + super.rawExpression();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        byte[] tableBytes = Bytes.readByteArray((DataInput)in);
        if (tableBytes.length > 0) {
            this.table = TableName.valueOf((byte[])tableBytes);
        }
        if (in.readBoolean()) {
            this.family = Bytes.readByteArray((DataInput)in);
        }
        if (in.readBoolean()) {
            this.qualifier = Bytes.readByteArray((DataInput)in);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Bytes.writeByteArray((DataOutput)out, this.table == null ? null : this.table.getName());
        out.writeBoolean(this.family != null);
        if (this.family != null) {
            Bytes.writeByteArray((DataOutput)out, (byte[])this.family);
        }
        out.writeBoolean(this.qualifier != null);
        if (this.qualifier != null) {
            Bytes.writeByteArray((DataOutput)out, (byte[])this.qualifier);
        }
    }
}

