/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.struct;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.loader.constant.Checkable;
import org.apache.hugegraph.loader.constant.Constants;
import org.apache.hugegraph.loader.constant.ElemType;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.loader.mapping.BackendStoreInfo;
import org.apache.hugegraph.loader.struct.EdgeStructV1;
import org.apache.hugegraph.loader.struct.ElementStructV1;
import org.apache.hugegraph.loader.struct.VertexStructV1;
import org.apache.hugegraph.loader.util.JsonUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Deprecated
public class GraphStructV1
implements Checkable {
    private static final Logger LOG = Log.logger(GraphStructV1.class);
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="vertices")
    private final List<VertexStructV1> vertexStructs = new ArrayList<VertexStructV1>();
    @JsonProperty(value="edges")
    private final List<EdgeStructV1> edgeStructs = new ArrayList<EdgeStructV1>();
    @JsonProperty(value="backendStoreInfo")
    private BackendStoreInfo backendStoreInfo;

    public static GraphStructV1 of(LoadContext context) {
        LoadOptions options = context.options();
        File file = FileUtils.getFile((String[])new String[]{options.file});
        try {
            String json = FileUtils.readFileToString((File)file, (Charset)Constants.CHARSET);
            GraphStructV1 struct = JsonUtil.fromJson(json, GraphStructV1.class);
            struct.check();
            return struct;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new LoadException("Failed to parse graph mapping description file '%s'", (Throwable)e, options.file);
        }
    }

    public BackendStoreInfo getBackendStoreInfo() {
        return this.backendStoreInfo;
    }

    @Override
    public void check() throws IllegalArgumentException {
        LOG.info("Checking vertex mapping descriptions");
        this.vertexStructs.forEach(VertexStructV1::check);
        this.checkNoSameStruct(this.vertexStructs);
        LOG.info("Checking edge mapping descriptions");
        this.edgeStructs.forEach(EdgeStructV1::check);
        this.checkNoSameStruct(this.edgeStructs);
    }

    public <ES extends ElementStructV1> List<ES> structs(ElemType type) {
        if (type.isVertex()) {
            return this.vertexStructs;
        }
        assert (type.isEdge());
        return this.edgeStructs;
    }

    public <ES extends ElementStructV1> List<ES> structs() {
        return ListUtils.union(this.vertexStructs, this.edgeStructs);
    }

    private <ES extends ElementStructV1> void checkNoSameStruct(List<ES> structs) {
        Set uniqueKeys = structs.stream().map(ElementStructV1::uniqueKey).collect(Collectors.toSet());
        E.checkArgument((structs.size() == uniqueKeys.size() ? 1 : 0) != 0, (String)"Please ensure there is no same mapping in %s", (Object[])new Object[]{structs});
    }
}

