/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.service.schema;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.entity.schema.ConflictDetail;
import org.apache.hugegraph.entity.schema.ConflictStatus;
import org.apache.hugegraph.entity.schema.PropertyIndex;
import org.apache.hugegraph.entity.schema.SchemaConflict;
import org.apache.hugegraph.entity.schema.SchemaEntity;
import org.apache.hugegraph.entity.schema.SchemaType;
import org.apache.hugegraph.exception.ServerException;
import org.apache.hugegraph.service.schema.SchemaService;
import org.apache.hugegraph.structure.constant.HugeType;
import org.apache.hugegraph.structure.schema.IndexLabel;
import org.apache.hugegraph.util.PageUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PropertyIndexService
extends SchemaService {
    private static final Logger log = LogManager.getLogger(PropertyIndexService.class);

    public List<PropertyIndex> list(int connId) {
        return this.list(Collections.emptyList(), connId);
    }

    public List<PropertyIndex> list(Collection<String> names, int connId) {
        return this.list(names, connId, true);
    }

    public List<PropertyIndex> list(Collection<String> names, int connId, boolean emptyAsAll) {
        HugeClient client = this.client(connId);
        List indexLabels = CollectionUtils.isEmpty(names) ? (emptyAsAll ? client.schema().getIndexLabels() : new ArrayList()) : client.schema().getIndexLabels(new ArrayList<String>(names));
        ArrayList<PropertyIndex> results = new ArrayList<PropertyIndex>(indexLabels.size());
        indexLabels.forEach(indexLabel -> results.add(PropertyIndexService.convert(indexLabel)));
        return results;
    }

    public IPage<PropertyIndex> list(int connId, HugeType type, int pageNo, int pageSize) {
        HugeClient client = this.client(connId);
        List indexLabels = client.schema().getIndexLabels();
        ArrayList<PropertyIndex> results = new ArrayList<PropertyIndex>();
        for (IndexLabel indexLabel : indexLabels) {
            if (!indexLabel.baseType().equals((Object)type)) continue;
            results.add(PropertyIndexService.convert(indexLabel));
        }
        results.sort((o1, o2) -> {
            String owner2;
            String owner1 = o1.getOwner();
            if (!owner1.equals(owner2 = o2.getOwner())) {
                return owner1.compareTo(owner2);
            }
            return o1.getName().compareTo(o2.getName());
        });
        return PageUtil.page(results, pageNo, pageSize);
    }

    public IPage<PropertyIndex> list(int connId, HugeType type, final String content, int pageNo, int pageSize) {
        HugeClient client = this.client(connId);
        List indexLabels = client.schema().getIndexLabels();
        HashMap<String, List> matchedResults = new HashMap<String, List>();
        HashMap<String, List> unMatchResults = new HashMap<String, List>();
        for (IndexLabel indexLabel : indexLabels) {
            if (!indexLabel.baseType().equals((Object)type)) continue;
            String baseValue = indexLabel.baseValue();
            boolean match = baseValue.contains(content);
            List groupedIndexes = match ? matchedResults.computeIfAbsent(baseValue, k -> new ArrayList()) : unMatchResults.computeIfAbsent(baseValue, k -> new ArrayList());
            if (!(match = match || indexLabel.name().contains(content) || indexLabel.indexFields().stream().anyMatch(f -> f.contains(content)))) continue;
            groupedIndexes.add(PropertyIndexService.convert(indexLabel));
        }
        if (!StringUtils.isEmpty((Object)content)) {
            for (Map.Entry entry : matchedResults.entrySet()) {
                List groupedIndexes = (List)entry.getValue();
                groupedIndexes.sort(new Comparator<PropertyIndex>(){
                    final int highScore = 2;
                    final int lowScore = 1;

                    @Override
                    public int compare(PropertyIndex o1, PropertyIndex o2) {
                        int o1Score = 0;
                        if (o1.getName().contains(content)) {
                            o1Score += 2;
                        }
                        if (o1.getFields().stream().anyMatch(field -> field.contains(content))) {
                            ++o1Score;
                        }
                        int o2Score = 0;
                        if (o2.getName().contains(content)) {
                            o2Score += 2;
                        }
                        if (o2.getFields().stream().anyMatch(field -> field.contains(content))) {
                            ++o2Score;
                        }
                        return o2Score - o1Score;
                    }
                });
            }
        }
        ArrayList all = new ArrayList();
        matchedResults.values().forEach(all::addAll);
        unMatchResults.values().forEach(all::addAll);
        return PageUtil.page(all, pageNo, pageSize);
    }

    private PropertyIndex get(String name, int connId) {
        HugeClient client = this.client(connId);
        try {
            IndexLabel indexLabel = client.schema().getIndexLabel(name);
            return PropertyIndexService.convert(indexLabel);
        }
        catch (ServerException e) {
            if (e.status() == 404) {
                return null;
            }
            throw e;
        }
    }

    public List<Long> addBatch(List<IndexLabel> indexLabels, HugeClient client) {
        BiFunction<HugeClient, IndexLabel, Long> func = (hugeClient, il) -> hugeClient.schema().addIndexLabelAsync(il);
        return PropertyIndexService.addBatch(indexLabels, client, func, SchemaType.PROPERTY_INDEX);
    }

    public List<Long> removeBatch(List<String> indexLabels, HugeClient client) {
        BiFunction<HugeClient, String, Long> func = (hugeClient, name) -> hugeClient.schema().removeIndexLabelAsync(name);
        return PropertyIndexService.removeBatch(indexLabels, client, func, SchemaType.PROPERTY_INDEX);
    }

    public void checkConflict(List<PropertyIndex> entities, ConflictDetail detail, int connId, boolean compareEachOther) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        HashMap<String, PropertyIndex> originEntities = new HashMap<String, PropertyIndex>();
        for (PropertyIndex entity : this.list(connId)) {
            originEntities.put(entity.getName(), entity);
        }
        for (PropertyIndex entity : entities) {
            if (detail.anyPropertyKeyConflict(entity.getFields())) {
                detail.add(entity, ConflictStatus.DEP_CONFLICT);
                continue;
            }
            PropertyIndex originEntity = (PropertyIndex)originEntities.get(entity.getName());
            ConflictStatus status = SchemaEntity.compare(entity, originEntity);
            detail.add(entity, status);
        }
        if (compareEachOther) {
            PropertyIndexService.compareWithEachOther(detail, SchemaType.PROPERTY_INDEX);
        }
    }

    public ConflictStatus checkConflict(PropertyIndex entity, int connId) {
        HugeClient client = this.client(connId);
        String name = entity.getName();
        IndexLabel newIndexLabel = PropertyIndexService.convert(entity, client);
        IndexLabel oldIndexLabel = PropertyIndexService.convert(this.get(name, connId), client);
        if (oldIndexLabel == null) {
            return ConflictStatus.PASSED;
        }
        if (PropertyIndexService.isEqual(newIndexLabel, oldIndexLabel)) {
            return ConflictStatus.EXISTED;
        }
        return ConflictStatus.DUPNAME;
    }

    public List<IndexLabel> filter(ConflictDetail detail, HugeClient client) {
        return detail.getPiConflicts().stream().filter(c -> c.getStatus() == ConflictStatus.PASSED).map(SchemaConflict::getEntity).map(e -> PropertyIndexService.convert(e, client)).collect(Collectors.toList());
    }

    public static PropertyIndex convert(IndexLabel indexLabel) {
        return PropertyIndex.builder().owner(indexLabel.baseValue()).ownerType(SchemaType.convert(indexLabel.baseType())).name(indexLabel.name()).type(indexLabel.indexType()).fields(indexLabel.indexFields()).build();
    }

    public static IndexLabel convert(PropertyIndex entity, HugeClient client) {
        if (entity == null) {
            return null;
        }
        boolean isVertex = entity.getOwnerType().isVertexLabel();
        String[] fields = PropertyIndexService.toStringArray(entity.getFields());
        return (IndexLabel)client.schema().indexLabel(entity.getName()).on(isVertex, entity.getOwner()).indexType(entity.getType()).by(fields).build();
    }

    private static boolean isEqual(IndexLabel oldSchema, IndexLabel newSchema) {
        return oldSchema.name().equals(newSchema.name()) && oldSchema.baseType().equals((Object)newSchema.baseType()) && oldSchema.baseValue().equals(newSchema.baseValue()) && oldSchema.indexType().equals((Object)newSchema.indexType()) && oldSchema.indexFields().equals(newSchema.indexFields());
    }
}

