/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.service.license;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.entity.GraphConnection;
import org.apache.hugegraph.handler.MessageSourceHandler;
import org.apache.hugegraph.service.GraphConnectionService;
import org.apache.hugegraph.service.HugeClientPoolService;
import org.apache.hugegraph.util.Ex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class LicenseService {
    private static final String METRICS_DATA_SIZE = "data_size";
    @Autowired
    private GraphConnectionService connService;
    @Autowired
    private HugeClientPoolService poolService;
    @Autowired
    private MessageSourceHandler messageHandler;

    public VerifyResult verifyGraphs(int actualGraphs) {
        return new VerifyResult(true);
    }

    @Async
    @Scheduled(fixedRate=180000L)
    public void updateAllGraphStatus() {
        List<GraphConnection> connections = this.connService.listAll();
        for (GraphConnection conn : connections) {
            this.updateGraphStatus(conn);
        }
    }

    private void updateGraphStatus(GraphConnection conn) {
        try {
            HugeClient client = this.poolService.getOrCreate(conn.getId());
        }
        catch (Exception e) {
            String msg = this.getMessage("graph-connection.client.unavailable", conn.getName());
            conn.setEnabled(false);
            conn.setDisableReason(msg);
            this.connService.update(conn);
            return;
        }
        conn.setEnabled(true);
        conn.setDisableReason("");
        this.connService.update(conn);
    }

    private String getMessage(String msgKey, Object ... args) {
        return this.messageHandler.getMessage(msgKey, args);
    }

    private static long getActualDataSize(HugeClient client, String graph) {
        Map metrics = client.metrics().backend(graph);
        Object dataSize = metrics.get(METRICS_DATA_SIZE);
        if (dataSize == null) {
            return 0L;
        }
        Ex.check(dataSize instanceof String, "The backend metrics data_size must be String type, but got '%s'(%s)", dataSize, dataSize.getClass());
        return LicenseService.displaySizeToMB((String)dataSize);
    }

    private static long displaySizeToMB(String displaySize) {
        String[] parts = displaySize.split(" ");
        Ex.check(parts.length == 2, "The displaySize must be formatted as two parts", new Object[0]);
        long numberPart = Long.parseLong(parts[0]);
        long byteCount = 0L;
        switch (parts[1]) {
            case "bytes": {
                byteCount = numberPart;
                break;
            }
            case "KB": {
                byteCount = numberPart * 1024L;
                break;
            }
            case "MB": {
                byteCount = numberPart * 0x100000L;
                break;
            }
            case "GB": {
                byteCount = numberPart * 0x40000000L;
                break;
            }
            case "TB": {
                byteCount = numberPart * 0x10000000000L;
                break;
            }
            case "PB": {
                byteCount = numberPart * 0x4000000000000L;
                break;
            }
            case "EB": {
                byteCount = numberPart * 0x1000000000000000L;
                break;
            }
        }
        return byteCount / 0x100000L;
    }

    public class VerifyResult {
        private final boolean enabled;
        private final String graphsMessage;
        private final List<String> dataSizeMessages;

        public VerifyResult(boolean enabled) {
            this(enabled, null);
        }

        public VerifyResult(boolean enabled, String graphsMessage) {
            this.enabled = enabled;
            this.graphsMessage = graphsMessage;
            this.dataSizeMessages = new ArrayList<String>();
        }

        public void add(String disableReason) {
            this.dataSizeMessages.add(disableReason);
        }

        public String getMessage() {
            if (this.enabled) {
                return null;
            }
            String comma = LicenseService.this.getMessage("common.joiner.comma", new Object[0]);
            String semicolon = LicenseService.this.getMessage("common.joiner.semicolon", new Object[0]);
            StringBuilder sb = new StringBuilder();
            sb.append(LicenseService.this.getMessage("license.verify.graph-connection.failed.preifx", new Object[0]));
            sb.append(comma);
            if (!StringUtils.isEmpty((CharSequence)this.graphsMessage)) {
                sb.append(this.graphsMessage);
                sb.append(semicolon);
            }
            if (!this.dataSizeMessages.isEmpty()) {
                for (String dataSizeMsg : this.dataSizeMessages) {
                    if (StringUtils.isEmpty((CharSequence)dataSizeMsg)) continue;
                    sb.append(dataSizeMsg);
                    sb.append(comma);
                }
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(comma);
            sb.append(LicenseService.this.getMessage("license.verify.graph-connection.failed.suffix", new Object[0]));
            return sb.toString();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getGraphsMessage() {
            return this.graphsMessage;
        }

        public List<String> getDataSizeMessages() {
            return this.dataSizeMessages;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerifyResult)) {
                return false;
            }
            VerifyResult other = (VerifyResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$graphsMessage = this.getGraphsMessage();
            String other$graphsMessage = other.getGraphsMessage();
            if (this$graphsMessage == null ? other$graphsMessage != null : !this$graphsMessage.equals(other$graphsMessage)) {
                return false;
            }
            List<String> this$dataSizeMessages = this.getDataSizeMessages();
            List<String> other$dataSizeMessages = other.getDataSizeMessages();
            return !(this$dataSizeMessages == null ? other$dataSizeMessages != null : !((Object)this$dataSizeMessages).equals(other$dataSizeMessages));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VerifyResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $graphsMessage = this.getGraphsMessage();
            result = result * 59 + ($graphsMessage == null ? 43 : $graphsMessage.hashCode());
            List<String> $dataSizeMessages = this.getDataSizeMessages();
            result = result * 59 + ($dataSizeMessages == null ? 43 : ((Object)$dataSizeMessages).hashCode());
            return result;
        }

        public String toString() {
            return "LicenseService.VerifyResult(enabled=" + this.isEnabled() + ", graphsMessage=" + this.getGraphsMessage() + ", dataSizeMessages=" + this.getDataSizeMessages() + ")";
        }

        public VerifyResult(boolean enabled, String graphsMessage, List<String> dataSizeMessages) {
            this.enabled = enabled;
            this.graphsMessage = graphsMessage;
            this.dataSizeMessages = dataSizeMessages;
        }
    }
}

