/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnSetInfo;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.DataOutputBuffer;

public class VectorGroupKeyHelper
extends VectorColumnSetInfo {
    private int[] inputColumnNums;

    public VectorGroupKeyHelper(int keyCount) {
        super(keyCount);
    }

    void init(VectorExpression[] keyExpressions) throws HiveException {
        this.inputColumnNums = new int[this.keyCount];
        for (int i = 0; i < this.keyCount; ++i) {
            int inputColumnNum;
            VectorExpression keyExpression = keyExpressions[i];
            TypeInfo typeInfo = keyExpression.getOutputTypeInfo();
            this.addKey(typeInfo);
            this.inputColumnNums[i] = inputColumnNum = keyExpression.getOutputColumnNum();
        }
        this.finishAdding();
    }

    public void copyGroupKey(VectorizedRowBatch inputBatch, VectorizedRowBatch outputBatch, DataOutputBuffer buffer) throws HiveException {
        ColumnVector outputColumnVector;
        ColumnVector inputColumnVector;
        int inputColumnNum;
        int outputColumnNum;
        int i;
        for (i = 0; i < this.longIndices.length; ++i) {
            outputColumnNum = this.longIndices[i];
            inputColumnNum = this.inputColumnNums[outputColumnNum];
            inputColumnVector = (LongColumnVector)inputBatch.cols[inputColumnNum];
            outputColumnVector = (LongColumnVector)outputBatch.cols[outputColumnNum];
            if (inputColumnVector.noNulls || !inputColumnVector.isNull[0]) {
                ((LongColumnVector)outputColumnVector).vector[outputBatch.size] = inputColumnVector.vector[0];
                continue;
            }
            ((LongColumnVector)outputColumnVector).noNulls = false;
            ((LongColumnVector)outputColumnVector).isNull[outputBatch.size] = true;
        }
        for (i = 0; i < this.doubleIndices.length; ++i) {
            outputColumnNum = this.doubleIndices[i];
            inputColumnNum = this.inputColumnNums[outputColumnNum];
            inputColumnVector = (DoubleColumnVector)inputBatch.cols[inputColumnNum];
            outputColumnVector = (DoubleColumnVector)outputBatch.cols[outputColumnNum];
            if (((DoubleColumnVector)inputColumnVector).noNulls || !((DoubleColumnVector)inputColumnVector).isNull[0]) {
                ((DoubleColumnVector)outputColumnVector).vector[outputBatch.size] = ((DoubleColumnVector)inputColumnVector).vector[0];
                continue;
            }
            ((DoubleColumnVector)outputColumnVector).noNulls = false;
            ((DoubleColumnVector)outputColumnVector).isNull[outputBatch.size] = true;
        }
        for (i = 0; i < this.stringIndices.length; ++i) {
            outputColumnNum = this.stringIndices[i];
            inputColumnNum = this.inputColumnNums[outputColumnNum];
            inputColumnVector = (BytesColumnVector)inputBatch.cols[inputColumnNum];
            outputColumnVector = (BytesColumnVector)outputBatch.cols[outputColumnNum];
            if (((BytesColumnVector)inputColumnVector).noNulls || !((BytesColumnVector)inputColumnVector).isNull[0]) {
                int start = buffer.getLength();
                int length = ((BytesColumnVector)inputColumnVector).length[0];
                try {
                    buffer.write(((BytesColumnVector)inputColumnVector).vector[0], ((BytesColumnVector)inputColumnVector).start[0], length);
                }
                catch (IOException ioe) {
                    throw new IllegalStateException("bad write", ioe);
                }
                ((BytesColumnVector)outputColumnVector).setRef(outputBatch.size, buffer.getData(), start, length);
                continue;
            }
            ((BytesColumnVector)outputColumnVector).noNulls = false;
            ((BytesColumnVector)outputColumnVector).isNull[outputBatch.size] = true;
        }
        for (i = 0; i < this.decimalIndices.length; ++i) {
            outputColumnNum = this.decimalIndices[i];
            inputColumnNum = this.inputColumnNums[outputColumnNum];
            inputColumnVector = (DecimalColumnVector)inputBatch.cols[inputColumnNum];
            outputColumnVector = (DecimalColumnVector)outputBatch.cols[outputColumnNum];
            if (((DecimalColumnVector)inputColumnVector).noNulls || !((DecimalColumnVector)inputColumnVector).isNull[0]) {
                ((DecimalColumnVector)outputColumnVector).set(outputBatch.size, ((DecimalColumnVector)inputColumnVector).vector[0]);
                continue;
            }
            ((DecimalColumnVector)outputColumnVector).noNulls = false;
            ((DecimalColumnVector)outputColumnVector).isNull[outputBatch.size] = true;
        }
        for (i = 0; i < this.timestampIndices.length; ++i) {
            outputColumnNum = this.timestampIndices[i];
            inputColumnNum = this.inputColumnNums[outputColumnNum];
            inputColumnVector = (TimestampColumnVector)inputBatch.cols[inputColumnNum];
            outputColumnVector = (TimestampColumnVector)outputBatch.cols[outputColumnNum];
            if (((TimestampColumnVector)inputColumnVector).noNulls || !((TimestampColumnVector)inputColumnVector).isNull[0]) {
                ((TimestampColumnVector)outputColumnVector).isNull[outputBatch.size] = false;
                ((TimestampColumnVector)outputColumnVector).setElement(outputBatch.size, 0, inputColumnVector);
                continue;
            }
            ((TimestampColumnVector)outputColumnVector).noNulls = false;
            ((TimestampColumnVector)outputColumnVector).isNull[outputBatch.size] = true;
        }
        for (i = 0; i < this.intervalDayTimeIndices.length; ++i) {
            outputColumnNum = this.intervalDayTimeIndices[i];
            inputColumnNum = this.inputColumnNums[outputColumnNum];
            inputColumnVector = (IntervalDayTimeColumnVector)inputBatch.cols[inputColumnNum];
            outputColumnVector = (IntervalDayTimeColumnVector)outputBatch.cols[outputColumnNum];
            if (((IntervalDayTimeColumnVector)inputColumnVector).noNulls || !((IntervalDayTimeColumnVector)inputColumnVector).isNull[0]) {
                ((IntervalDayTimeColumnVector)outputColumnVector).isNull[outputBatch.size] = false;
                ((IntervalDayTimeColumnVector)outputColumnVector).setElement(outputBatch.size, 0, inputColumnVector);
                continue;
            }
            ((IntervalDayTimeColumnVector)outputColumnVector).noNulls = false;
            ((IntervalDayTimeColumnVector)outputColumnVector).isNull[outputBatch.size] = true;
        }
    }
}

