/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.columnstats.cache.DoubleColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;

public class DoubleColumnStatsMerger
extends ColumnStatsMerger {
    @Override
    public void merge(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        DoubleColumnStatsDataInspector aggregateData = (DoubleColumnStatsDataInspector)aggregateColStats.getStatsData().getDoubleStats();
        DoubleColumnStatsDataInspector newData = (DoubleColumnStatsDataInspector)newColStats.getStatsData().getDoubleStats();
        aggregateData.setLowValue(Math.min(aggregateData.getLowValue(), newData.getLowValue()));
        aggregateData.setHighValue(Math.max(aggregateData.getHighValue(), newData.getHighValue()));
        aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
        if (aggregateData.getNdvEstimator() == null || newData.getNdvEstimator() == null) {
            aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
        } else {
            NumDistinctValueEstimator oldEst = aggregateData.getNdvEstimator();
            NumDistinctValueEstimator newEst = newData.getNdvEstimator();
            long ndv = -1L;
            if (oldEst.canMerge(newEst)) {
                oldEst.mergeEstimators(newEst);
                ndv = oldEst.estimateNumDistinctValues();
                aggregateData.setNdvEstimator(oldEst);
            } else {
                ndv = Math.max(aggregateData.getNumDVs(), newData.getNumDVs());
            }
            this.LOG.debug("Use bitvector to merge column " + aggregateColStats.getColName() + "'s ndvs of " + aggregateData.getNumDVs() + " and " + newData.getNumDVs() + " to be " + ndv);
            aggregateData.setNumDVs(ndv);
        }
    }
}

