/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;

public enum LlapDaemonInfo {
    INSTANCE;

    private AtomicReference<LlapDaemonInfoHolder> dataRef = new AtomicReference();

    public static void initialize(String appName, Configuration daemonConf) {
        int numExecutors = HiveConf.getIntVar(daemonConf, HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS);
        long executorMemoryBytes = (long)HiveConf.getIntVar(daemonConf, HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB) * 1024L * 1024L;
        long ioMemoryBytes = HiveConf.getSizeVar(daemonConf, HiveConf.ConfVars.LLAP_IO_MEMORY_MAX_SIZE);
        boolean isDirectCache = HiveConf.getBoolVar(daemonConf, HiveConf.ConfVars.LLAP_ALLOCATOR_DIRECT);
        boolean isLlapIo = HiveConf.getBoolVar(daemonConf, HiveConf.ConfVars.LLAP_IO_ENABLED, true);
        String pid = System.getenv("JVM_PID");
        LlapDaemonInfo.initialize(appName, numExecutors, executorMemoryBytes, ioMemoryBytes, isDirectCache, isLlapIo, pid);
    }

    public static void initialize(String appName, int numExecutors, long executorMemoryBytes, long ioMemoryBytes, boolean isDirectCache, boolean isLlapIo, String pid) {
        LlapDaemonInfo.INSTANCE.dataRef.set(new LlapDaemonInfoHolder(numExecutors, executorMemoryBytes, ioMemoryBytes, isDirectCache, isLlapIo, pid));
    }

    public boolean isLlap() {
        return this.dataRef.get() != null;
    }

    public int getNumExecutors() {
        return this.dataRef.get().numExecutors;
    }

    public long getExecutorMemory() {
        return this.dataRef.get().executorMemory;
    }

    public long getMemoryPerExecutor() {
        LlapDaemonInfoHolder data = this.dataRef.get();
        return (this.getExecutorMemory() - -(data.isDirectCache ? 0L : data.cacheSize)) / (long)this.getNumExecutors();
    }

    public long getCacheSize() {
        return this.dataRef.get().cacheSize;
    }

    public boolean isDirectCache() {
        return this.dataRef.get().isDirectCache;
    }

    public boolean isLlapIo() {
        return this.dataRef.get().isLlapIo;
    }

    public String getPID() {
        return this.dataRef.get().PID;
    }

    private static final class LlapDaemonInfoHolder {
        final int numExecutors;
        final long executorMemory;
        final long cacheSize;
        final boolean isDirectCache;
        final boolean isLlapIo;
        final String PID;

        public LlapDaemonInfoHolder(int numExecutors, long executorMemory, long cacheSize, boolean isDirectCache, boolean isLlapIo, String pid) {
            this.numExecutors = numExecutors;
            this.executorMemory = executorMemory;
            this.cacheSize = cacheSize;
            this.isDirectCache = isDirectCache;
            this.isLlapIo = isLlapIo;
            this.PID = pid;
        }
    }
}

