/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tezplugins.scheduler;

import com.google.common.util.concurrent.FutureCallback;
import java.util.concurrent.CancellationException;
import org.slf4j.Logger;

public final class LoggingFutureCallback
implements FutureCallback<Void> {
    private final String componentName;
    private final Logger LOG;

    public LoggingFutureCallback(String componentName, Logger log) {
        this.componentName = componentName;
        this.LOG = log;
    }

    public void onSuccess(Void result) {
        this.LOG.info("{} exited", (Object)this.componentName);
    }

    public void onFailure(Throwable t) {
        if (t instanceof CancellationException) {
            this.LOG.info("{} was cancelled", (Object)this.componentName, (Object)t.getMessage());
        } else {
            this.LOG.warn("{} exited with error", (Object)this.componentName, (Object)t);
        }
    }
}

