/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.function.Supplier;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthWebEndpointResponseMapper;
import org.springframework.boot.actuate.health.ShowDetails;

@EndpointWebExtension(endpoint=HealthEndpoint.class)
public class HealthEndpointWebExtension {
    private final HealthEndpoint delegate;
    private final HealthWebEndpointResponseMapper responseMapper;

    public HealthEndpointWebExtension(HealthEndpoint delegate, HealthWebEndpointResponseMapper responseMapper) {
        this.delegate = delegate;
        this.responseMapper = responseMapper;
    }

    @ReadOperation
    public WebEndpointResponse<Health> health(SecurityContext securityContext) {
        return this.responseMapper.map(this.delegate.health(), securityContext);
    }

    @ReadOperation
    public WebEndpointResponse<Health> healthForComponent(SecurityContext securityContext, @Selector String component) {
        Supplier<Health> health = () -> this.delegate.healthForComponent(component);
        return this.responseMapper.mapDetails(health, securityContext);
    }

    @ReadOperation
    public WebEndpointResponse<Health> healthForComponentInstance(SecurityContext securityContext, @Selector String component, @Selector String instance) {
        Supplier<Health> health = () -> this.delegate.healthForComponentInstance(component, instance);
        return this.responseMapper.mapDetails(health, securityContext);
    }

    public WebEndpointResponse<Health> getHealth(SecurityContext securityContext, ShowDetails showDetails) {
        return this.responseMapper.map(this.delegate.health(), securityContext, showDetails);
    }
}

