/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.boot.actuate.health.DefaultReactiveHealthIndicatorRegistry;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicatorRegistry;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class CompositeReactiveHealthIndicator
implements ReactiveHealthIndicator {
    private final ReactiveHealthIndicatorRegistry registry;
    private final HealthAggregator healthAggregator;
    private Long timeout;
    private Health timeoutHealth;
    private final Function<Mono<Health>, Mono<Health>> timeoutCompose;

    @Deprecated
    public CompositeReactiveHealthIndicator(HealthAggregator healthAggregator) {
        this(healthAggregator, new LinkedHashMap<String, ReactiveHealthIndicator>());
    }

    @Deprecated
    public CompositeReactiveHealthIndicator(HealthAggregator healthAggregator, Map<String, ReactiveHealthIndicator> indicators) {
        this(healthAggregator, new DefaultReactiveHealthIndicatorRegistry(indicators));
    }

    public CompositeReactiveHealthIndicator(HealthAggregator healthAggregator, ReactiveHealthIndicatorRegistry registry) {
        this.registry = registry;
        this.healthAggregator = healthAggregator;
        this.timeoutCompose = mono -> this.timeout != null ? mono.timeout(Duration.ofMillis(this.timeout), Mono.just((Object)this.timeoutHealth)) : mono;
    }

    @Deprecated
    public CompositeReactiveHealthIndicator addHealthIndicator(String name, ReactiveHealthIndicator indicator) {
        this.registry.register(name, indicator);
        return this;
    }

    public CompositeReactiveHealthIndicator timeoutStrategy(long timeout, Health timeoutHealth) {
        this.timeout = timeout;
        this.timeoutHealth = timeoutHealth != null ? timeoutHealth : Health.unknown().build();
        return this;
    }

    ReactiveHealthIndicatorRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public Mono<Health> health() {
        return Flux.fromIterable(this.registry.getAll().entrySet()).flatMap(entry -> Mono.zip((Mono)Mono.just(entry.getKey()), (Mono)((ReactiveHealthIndicator)entry.getValue()).health().compose(this.timeoutCompose))).collectMap(Tuple2::getT1, Tuple2::getT2).map(this.healthAggregator::aggregate);
    }
}

