/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.datanode.web.DatanodeHttpServer;
import org.apache.hadoop.security.http.RestCsrfPreventionFilter;
import org.slf4j.Logger;

@InterfaceAudience.Private
@ChannelHandler.Sharable
final class RestCsrfPreventionFilterHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private static final Logger LOG = DatanodeHttpServer.LOG;
    private final RestCsrfPreventionFilter restCsrfPreventionFilter;

    RestCsrfPreventionFilterHandler(RestCsrfPreventionFilter restCsrfPreventionFilter) {
        if (restCsrfPreventionFilter == null) {
            LOG.warn("Got null for restCsrfPreventionFilter - will not do any filtering.");
        }
        this.restCsrfPreventionFilter = restCsrfPreventionFilter;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest req) throws Exception {
        if (this.restCsrfPreventionFilter != null) {
            this.restCsrfPreventionFilter.handleHttpInteraction((RestCsrfPreventionFilter.HttpInteraction)new NettyHttpInteraction(ctx, req));
        } else {
            new NettyHttpInteraction(ctx, req).proceed();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.error("Exception in " + ((Object)((Object)this)).getClass().getSimpleName(), cause);
        RestCsrfPreventionFilterHandler.sendResponseAndClose(ctx, new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR));
    }

    private static void sendResponseAndClose(ChannelHandlerContext ctx, DefaultHttpResponse resp) {
        resp.headers().set("Connection", (Object)"close");
        ctx.writeAndFlush((Object)resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public static RestCsrfPreventionFilter initializeState(Configuration conf) {
        if (!conf.getBoolean("dfs.webhdfs.rest-csrf.enabled", false)) {
            return null;
        }
        String restCsrfClassName = RestCsrfPreventionFilter.class.getName();
        Map restCsrfParams = RestCsrfPreventionFilter.getFilterParams((Configuration)conf, (String)"dfs.webhdfs.rest-csrf.");
        RestCsrfPreventionFilter filter = new RestCsrfPreventionFilter();
        try {
            filter.init((FilterConfig)new DatanodeHttpServer.MapBasedFilterConfig(restCsrfClassName, restCsrfParams));
        }
        catch (ServletException e) {
            throw new IllegalStateException("Failed to initialize RestCsrfPreventionFilter.", e);
        }
        return filter;
    }

    private static final class NettyHttpInteraction
    implements RestCsrfPreventionFilter.HttpInteraction {
        private final ChannelHandlerContext ctx;
        private final HttpRequest req;

        NettyHttpInteraction(ChannelHandlerContext ctx, HttpRequest req) {
            this.ctx = ctx;
            this.req = req;
        }

        public String getHeader(String header) {
            return this.req.headers().get(header);
        }

        public String getMethod() {
            return this.req.getMethod().name();
        }

        public void proceed() {
            ReferenceCountUtil.retain((Object)this.req);
            this.ctx.fireChannelRead((Object)this.req);
        }

        public void sendError(int code, String message) {
            HttpResponseStatus status = new HttpResponseStatus(code, message);
            RestCsrfPreventionFilterHandler.sendResponseAndClose(this.ctx, new DefaultHttpResponse(HttpVersion.HTTP_1_1, status));
        }
    }
}

