/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.calcite.adapter.druid.DirectOperatorConversion;
import org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.ExtractOperatorConversion;
import org.apache.calcite.adapter.druid.FloorOperatorConversion;
import org.apache.calcite.adapter.druid.SubstringOperatorConversion;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveConcat;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveDateAddSqlOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveDateSubSqlOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveExtractDate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFloorDate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFromUnixTimeSqlOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveToDateSqlOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTruncSqlOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnixTimestampSqlOperator;
import org.joda.time.Period;

public class DruidSqlOperatorConverter {
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String DEFAULT_TS_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static Map druidOperatorMap = null;

    private DruidSqlOperatorConverter() {
    }

    public static final Map<SqlOperator, org.apache.calcite.adapter.druid.DruidSqlOperatorConverter> getDefaultMap() {
        if (druidOperatorMap == null) {
            druidOperatorMap = new HashMap();
            DruidQuery.DEFAULT_OPERATORS_LIST.stream().forEach(op -> druidOperatorMap.put(op.calciteOperator(), op));
            druidOperatorMap.putAll(Maps.asMap(HiveFloorDate.ALL_FUNCTIONS, input -> new FloorOperatorConversion()));
            druidOperatorMap.putAll(Maps.asMap(HiveExtractDate.ALL_FUNCTIONS, input -> new ExtractOperatorConversion()));
            druidOperatorMap.put(HiveConcat.INSTANCE, new DirectOperatorConversion((SqlOperator)HiveConcat.INSTANCE, "concat"));
            druidOperatorMap.put(SqlStdOperatorTable.SUBSTRING, new DruidSubstringOperatorConversion());
            druidOperatorMap.put(SqlStdOperatorTable.IS_NULL, new UnaryFunctionOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_NULL, "isnull"));
            druidOperatorMap.put(SqlStdOperatorTable.IS_NOT_NULL, new UnaryFunctionOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, "notnull"));
            druidOperatorMap.put(HiveTruncSqlOperator.INSTANCE, new DruidDateTruncOperatorConversion());
            druidOperatorMap.put(HiveToDateSqlOperator.INSTANCE, new DruidToDateOperatorConversion());
            druidOperatorMap.put(HiveFromUnixTimeSqlOperator.INSTANCE, new DruidFormUnixTimeOperatorConversion());
            druidOperatorMap.put(HiveUnixTimestampSqlOperator.INSTANCE, new DruidUnixTimestampOperatorConversion());
            druidOperatorMap.put(HiveDateAddSqlOperator.INSTANCE, new DruidDateArithmeticOperatorConversion(1, (SqlOperator)HiveDateAddSqlOperator.INSTANCE));
            druidOperatorMap.put(HiveDateSubSqlOperator.INSTANCE, new DruidDateArithmeticOperatorConversion(-1, (SqlOperator)HiveDateSubSqlOperator.INSTANCE));
        }
        return druidOperatorMap;
    }

    private static TimeZone timezoneId(DruidQuery query) {
        return TimeZone.getTimeZone(((CalciteConnectionConfig)query.getTopNode().getCluster().getPlanner().getContext().unwrap(CalciteConnectionConfig.class)).timeZone());
    }

    private static String applyTimestampFormat(String arg, String format, TimeZone timeZone) {
        return DruidExpressions.functionCall((String)"timestamp_format", ImmutableList.of(arg, DruidExpressions.stringLiteral((String)format), DruidExpressions.stringLiteral((String)timeZone.getID())));
    }

    public static class UnaryFunctionOperatorConversion
    implements org.apache.calcite.adapter.druid.DruidSqlOperatorConverter {
        private final SqlOperator operator;
        private final String druidOperator;

        public UnaryFunctionOperatorConversion(SqlOperator operator, String druidOperator) {
            this.operator = operator;
            this.druidOperator = druidOperator;
        }

        public SqlOperator calciteOperator() {
            return this.operator;
        }

        public String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery druidQuery) {
            RexCall call = (RexCall)rexNode;
            List druidExpressions = DruidExpressions.toDruidExpressions((DruidQuery)druidQuery, (RelDataType)rowType, (List)call.getOperands());
            if (druidExpressions == null) {
                return null;
            }
            return DruidQuery.format((String)"%s(%s)", (Object[])new Object[]{this.druidOperator, Iterables.getOnlyElement(druidExpressions)});
        }
    }

    public static class DruidDateArithmeticOperatorConversion
    implements org.apache.calcite.adapter.druid.DruidSqlOperatorConverter {
        private final int direction;
        private final SqlOperator operator;

        public DruidDateArithmeticOperatorConversion(int direction, SqlOperator operator) {
            this.direction = direction;
            this.operator = operator;
            Preconditions.checkArgument(direction == 1 || direction == -1);
        }

        public SqlOperator calciteOperator() {
            return this.operator;
        }

        @Nullable
        public String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery query) {
            RexCall call = (RexCall)rexNode;
            if (call.getOperands().size() != 2) {
                throw new IllegalStateException("date_add/date_sub() requires 2 arguments, got " + call.getOperands().size());
            }
            String arg0 = DruidExpressions.toDruidExpression((RexNode)((RexNode)call.getOperands().get(0)), (RelDataType)rowType, (DruidQuery)query);
            String arg1 = DruidExpressions.toDruidExpression((RexNode)((RexNode)call.getOperands().get(1)), (RelDataType)rowType, (DruidQuery)query);
            if (arg0 == null || arg1 == null) {
                return null;
            }
            String steps = this.direction == -1 ? DruidQuery.format((String)"-( %s )", (Object[])new Object[]{arg1}) : arg1;
            return DruidExpressions.functionCall((String)"timestamp_shift", ImmutableList.of(arg0, DruidExpressions.stringLiteral((String)"P1D"), steps, DruidExpressions.stringLiteral((String)DruidSqlOperatorConverter.timezoneId(query).getID())));
        }
    }

    public static class DruidFormUnixTimeOperatorConversion
    implements org.apache.calcite.adapter.druid.DruidSqlOperatorConverter {
        public SqlOperator calciteOperator() {
            return HiveFromUnixTimeSqlOperator.INSTANCE;
        }

        @Nullable
        public String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery query) {
            RexCall call = (RexCall)rexNode;
            if (call.getOperands().size() < 1 || call.getOperands().size() > 2) {
                throw new IllegalStateException("form_unixtime() requires 1 or 2 argument, got " + call.getOperands().size());
            }
            String arg = DruidExpressions.toDruidExpression((RexNode)((RexNode)call.getOperands().get(0)), (RelDataType)rowType, (DruidQuery)query);
            if (arg == null) {
                return null;
            }
            String numMillis = DruidQuery.format((String)"(%s * '1000')", (Object[])new Object[]{arg});
            String format = call.getOperands().size() == 1 ? DruidExpressions.stringLiteral((String)DruidSqlOperatorConverter.DEFAULT_TS_FORMAT) : DruidExpressions.toDruidExpression((RexNode)((RexNode)call.getOperands().get(1)), (RelDataType)rowType, (DruidQuery)query);
            return DruidExpressions.functionCall((String)"timestamp_format", ImmutableList.of(numMillis, format, DruidExpressions.stringLiteral((String)DruidSqlOperatorConverter.timezoneId(query).getID())));
        }
    }

    public static class DruidUnixTimestampOperatorConversion
    implements org.apache.calcite.adapter.druid.DruidSqlOperatorConverter {
        public SqlOperator calciteOperator() {
            return HiveUnixTimestampSqlOperator.INSTANCE;
        }

        @Nullable
        public String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery query) {
            RexCall call = (RexCall)rexNode;
            String arg0 = DruidExpressions.toDruidExpression((RexNode)((RexNode)call.getOperands().get(0)), (RelDataType)rowType, (DruidQuery)query);
            if (arg0 == null) {
                return null;
            }
            if (SqlTypeUtil.isDatetime((RelDataType)((RexNode)call.getOperands().get(0)).getType())) {
                return DruidExpressions.functionCall((String)"div", ImmutableList.of(arg0, DruidExpressions.numberLiteral((Number)1000)));
            }
            String format = call.getOperands().size() == 2 ? DruidExpressions.toDruidExpression((RexNode)((RexNode)call.getOperands().get(1)), (RelDataType)rowType, (DruidQuery)query) : DruidSqlOperatorConverter.DEFAULT_TS_FORMAT;
            return DruidExpressions.functionCall((String)"unix_timestamp", ImmutableList.of(arg0, DruidExpressions.stringLiteral((String)format)));
        }
    }

    public static class DruidToDateOperatorConversion
    implements org.apache.calcite.adapter.druid.DruidSqlOperatorConverter {
        public SqlOperator calciteOperator() {
            return HiveToDateSqlOperator.INSTANCE;
        }

        @Nullable
        public String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery query) {
            RexCall call = (RexCall)rexNode;
            if (call.getOperands().size() != 1) {
                throw new IllegalStateException("to_date() requires 1 argument, got " + call.getOperands().size());
            }
            String arg = DruidExpressions.toDruidExpression((RexNode)((RexNode)call.getOperands().get(0)), (RelDataType)rowType, (DruidQuery)query);
            if (arg == null) {
                return null;
            }
            return DruidExpressions.applyTimestampFloor((String)arg, (String)Period.days(1).toString(), (String)"", (TimeZone)DruidSqlOperatorConverter.timezoneId(query));
        }
    }

    public static class DruidDateTruncOperatorConversion
    implements org.apache.calcite.adapter.druid.DruidSqlOperatorConverter {
        public SqlOperator calciteOperator() {
            return HiveTruncSqlOperator.INSTANCE;
        }

        @Nullable
        public String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery query) {
            RexCall call = (RexCall)rexNode;
            if (call.getOperands().size() < 1) {
                throw new IllegalStateException("trunc() requires at least 1 argument, got " + call.getOperands().size());
            }
            if (call.getOperands().size() == 1) {
                String arg = DruidExpressions.toDruidExpression((RexNode)((RexNode)call.getOperands().get(0)), (RelDataType)rowType, (DruidQuery)query);
                if (arg == null) {
                    return null;
                }
                if (SqlTypeUtil.isDatetime((RelDataType)((RexNode)call.getOperands().get(0)).getType())) {
                    return DruidSqlOperatorConverter.applyTimestampFormat(DruidExpressions.applyTimestampFloor((String)arg, (String)Period.days(1).toString(), (String)"", (TimeZone)DruidSqlOperatorConverter.timezoneId(query)), DruidSqlOperatorConverter.YYYY_MM_DD, DruidSqlOperatorConverter.timezoneId(query));
                }
                return null;
            }
            if (call.getOperands().size() == 2) {
                String arg = DruidExpressions.toDruidExpression((RexNode)((RexNode)call.getOperands().get(0)), (RelDataType)rowType, (DruidQuery)query);
                if (arg == null) {
                    return null;
                }
                String granularity = DruidExpressions.toDruidExpression((RexNode)((RexNode)call.getOperands().get(1)), (RelDataType)rowType, (DruidQuery)query);
                if (granularity == null) {
                    return null;
                }
                String unit = "'MONTH'".equals(granularity) || "'MON'".equals(granularity) || "'MM'".equals(granularity) ? Period.months(1).toString() : ("'YEAR'".equals(granularity) || "'YYYY'".equals(granularity) || "'YY'".equals(granularity) ? Period.years(1).toString() : ("'QUARTER'".equals(granularity) || "'Q'".equals(granularity) ? Period.months(3).toString() : null));
                if (unit == null) {
                    return null;
                }
                return DruidSqlOperatorConverter.applyTimestampFormat(DruidExpressions.applyTimestampFloor((String)arg, (String)unit, (String)"", (TimeZone)DruidSqlOperatorConverter.timezoneId(query)), DruidSqlOperatorConverter.YYYY_MM_DD, DruidSqlOperatorConverter.timezoneId(query));
            }
            return null;
        }
    }

    public static class DruidSubstringOperatorConversion
    extends SubstringOperatorConversion {
        @Nullable
        public String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery query) {
            String length;
            String indexStart;
            RexCall call = (RexCall)rexNode;
            String arg = DruidExpressions.toDruidExpression((RexNode)((RexNode)call.getOperands().get(0)), (RelDataType)rowType, (DruidQuery)query);
            if (arg == null) {
                return null;
            }
            if (!((RexNode)call.getOperands().get(1)).isA(SqlKind.LITERAL)) {
                String indexExp = DruidExpressions.toDruidExpression((RexNode)((RexNode)call.getOperands().get(1)), (RelDataType)rowType, (DruidQuery)query);
                if (indexExp == null) {
                    return null;
                }
                indexStart = DruidQuery.format((String)"(%s - 1)", (Object[])new Object[]{indexExp});
            } else {
                int index = RexLiteral.intValue((RexNode)((RexNode)call.getOperands().get(1))) - 1;
                indexStart = DruidExpressions.numberLiteral((Number)index);
            }
            if (call.getOperands().size() > 2) {
                if (!((RexNode)call.getOperands().get(2)).isA(SqlKind.LITERAL)) {
                    length = DruidExpressions.toDruidExpression((RexNode)((RexNode)call.getOperands().get(2)), (RelDataType)rowType, (DruidQuery)query);
                    if (length == null) {
                        return null;
                    }
                } else {
                    length = DruidExpressions.numberLiteral((Number)RexLiteral.intValue((RexNode)((RexNode)call.getOperands().get(2))));
                }
            } else {
                length = DruidExpressions.numberLiteral((Number)-1);
            }
            return DruidQuery.format((String)"substring(%s, %s, %s)", (Object[])new Object[]{arg, indexStart, length});
        }
    }
}

