/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.extracting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ansj.app.extracting.domain.Rule;
import org.ansj.app.extracting.domain.Token;
import org.ansj.app.extracting.exception.RuleFormatException;
import org.nlpcn.commons.lang.util.StringUtil;

public class Lexical {
    private static final Map<Character, Character> MAP = new HashMap<Character, Character>();

    public static Rule parse(String line) throws RuleFormatException {
        if (StringUtil.isBlank((CharSequence)line)) {
            return null;
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        HashMap<String, int[]> groups = new HashMap<String, int[]>();
        HashMap<String, String> attr = new HashMap<String, String>();
        double weight = 1.0;
        String[] split = line.split("\t");
        String rule = split[0];
        ArrayList<String> list = new ArrayList<String>();
        block4: for (int i = 0; i < rule.length(); ++i) {
            switch (rule.charAt(i)) {
                case ' ': {
                    continue block4;
                }
                case '(': 
                case '[': 
                case '{': {
                    i = Lexical.makeToken(list, rule, i);
                    continue block4;
                }
                default: {
                    throw new RuleFormatException(rule + " not begin ( at index " + i);
                }
            }
        }
        Token token = null;
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            String str = (String)list.get(i);
            if (str.startsWith("(")) {
                Token tempToken = new Token(index, str);
                ++index;
                tokens.add(tempToken);
                if (token != null) {
                    token.setNext(tempToken);
                }
                token = tempToken;
                continue;
            }
            token.addAttr(str);
        }
        if (split.length > 1 && StringUtil.isNotBlank((CharSequence)split[1])) {
            String[] split1 = split[1].split(";");
            for (int i = 0; i < split1.length; ++i) {
                String[] split2 = split1[i].split(":");
                if (split2[1].startsWith("(")) {
                    attr.put(split2[0], split2[1].substring(1, split2[1].length() - 1));
                    continue;
                }
                String[] split3 = split2[1].split(",");
                int[] ints = new int[split3.length];
                for (int j = 0; j < ints.length; ++j) {
                    ints[j] = Integer.parseInt(split3[j].trim());
                }
                groups.put(split2[0], ints);
            }
        }
        if (split.length > 2 && StringUtil.isNotBlank((CharSequence)split[2])) {
            weight = Double.parseDouble(split[2]);
        }
        return new Rule(line, tokens, groups, attr, weight);
    }

    private static int makeToken(List<String> list, String rule, int i) {
        int j;
        int num = 0;
        StringBuilder sb = new StringBuilder();
        char begin = rule.charAt(i);
        char end = MAP.get(Character.valueOf(begin)).charValue();
        for (j = i; j < rule.length(); ++j) {
            char c = rule.charAt(j);
            if (c == '\\') {
                sb.append(rule.charAt(++j));
                continue;
            }
            sb.append(c);
            if (c == begin) {
                ++num;
            } else if (c == end) {
                --num;
            }
            if (num == 0) break;
        }
        list.add(sb.toString());
        return j;
    }

    static {
        MAP.put(Character.valueOf('('), Character.valueOf(')'));
        MAP.put(Character.valueOf('['), Character.valueOf(']'));
        MAP.put(Character.valueOf('{'), Character.valueOf('}'));
    }
}

