/*
 * Decompiled with CFR 0.152.
 */
package jflex.gui;

import java.io.File;
import java.util.Objects;
import jflex.core.OptionUtils;
import jflex.exceptions.GeneratorException;
import jflex.generator.LexGenerator;
import jflex.gui.MainFrame;
import jflex.l10n.ErrorMessages;
import jflex.logging.Out;

public class GeneratorThread
extends Thread {
    private static volatile boolean running = false;
    String inputFile;
    String outputDir;
    final MainFrame parent;

    public GeneratorThread(MainFrame parent, String inputFile, String outputDir) {
        this.parent = parent;
        this.inputFile = inputFile;
        this.outputDir = outputDir;
    }

    @Override
    public void run() {
        if (running) {
            Out.error(ErrorMessages.ALREADY_RUNNING);
            this.parent.generationFinished(false);
        } else {
            running = true;
            this.setPriority(1);
            try {
                if (!Objects.equals(this.outputDir, "")) {
                    OptionUtils.setDir(this.outputDir);
                }
                new LexGenerator(new File(this.inputFile)).generate();
                Out.statistics();
                this.parent.generationFinished(true);
            }
            catch (GeneratorException e) {
                Out.statistics();
                this.parent.generationFinished(false);
            }
            finally {
                running = false;
            }
        }
    }
}

