/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.util.Map;
import org.apache.hugegraph.util.E;

public class ParameterUtil {
    public static Object parameter(Map<String, Object> parameters, String key) {
        Object value = parameters.get(key);
        E.checkArgument((value != null ? 1 : 0) != 0, (String)"Expect '%s' in parameters: %s", (Object[])new Object[]{key, parameters});
        return value;
    }

    public static String parameterString(Map<String, Object> parameters, String key) {
        Object value = ParameterUtil.parameter(parameters, key);
        E.checkArgument((boolean)(value instanceof String), (String)"Expect string value for parameter '%s': '%s'", (Object[])new Object[]{key, value});
        return (String)value;
    }

    public static int parameterInt(Map<String, Object> parameters, String key) {
        Object value = ParameterUtil.parameter(parameters, key);
        E.checkArgument((boolean)(value instanceof Number), (String)"Expect int value for parameter '%s': '%s'", (Object[])new Object[]{key, value});
        return ((Number)value).intValue();
    }

    public static long parameterLong(Map<String, Object> parameters, String key) {
        Object value = ParameterUtil.parameter(parameters, key);
        E.checkArgument((boolean)(value instanceof Number), (String)"Expect long value for parameter '%s': '%s'", (Object[])new Object[]{key, value});
        return ((Number)value).longValue();
    }

    public static double parameterDouble(Map<String, Object> parameters, String key) {
        Object value = ParameterUtil.parameter(parameters, key);
        E.checkArgument((boolean)(value instanceof Number), (String)"Expect double value for parameter '%s': '%s'", (Object[])new Object[]{key, value});
        return ((Number)value).doubleValue();
    }

    public static boolean parameterBoolean(Map<String, Object> parameters, String key) {
        Object value = ParameterUtil.parameter(parameters, key);
        E.checkArgument((boolean)(value instanceof Boolean), (String)"Expect boolean value for parameter '%s': '%s'", (Object[])new Object[]{key, value});
        return (Boolean)value;
    }
}

