/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.type.define;

import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.SerialEnum;
import org.apache.tinkerpop.gremlin.structure.Direction;

public final class Directions
extends Enum<Directions>
implements SerialEnum {
    public static final /* enum */ Directions BOTH = new Directions(0, "both");
    public static final /* enum */ Directions OUT = new Directions(1, "out");
    public static final /* enum */ Directions IN = new Directions(2, "in");
    private byte code = 0;
    private String name = null;
    private static final /* synthetic */ Directions[] $VALUES;

    public static Directions[] values() {
        return (Directions[])$VALUES.clone();
    }

    public static Directions valueOf(String name) {
        return Enum.valueOf(Directions.class, name);
    }

    private Directions(int code, String name) {
        assert (code < 256);
        this.code = (byte)code;
        this.name = name;
    }

    @Override
    public byte code() {
        return this.code;
    }

    public String string() {
        return this.name;
    }

    public HugeType type() {
        switch (this) {
            case OUT: {
                return HugeType.EDGE_OUT;
            }
            case IN: {
                return HugeType.EDGE_IN;
            }
        }
        throw new IllegalArgumentException(String.format("Can't convert direction '%s' to HugeType", this));
    }

    public Directions opposite() {
        if (this.equals(OUT)) {
            return IN;
        }
        return this.equals(IN) ? OUT : BOTH;
    }

    public Direction direction() {
        switch (this) {
            case OUT: {
                return Direction.OUT;
            }
            case IN: {
                return Direction.IN;
            }
            case BOTH: {
                return Direction.BOTH;
            }
        }
        throw new AssertionError((Object)String.format("Unrecognized direction: '%s'", this));
    }

    public static Directions convert(Direction direction) {
        switch (direction) {
            case OUT: {
                return OUT;
            }
            case IN: {
                return IN;
            }
            case BOTH: {
                return BOTH;
            }
        }
        throw new AssertionError((Object)String.format("Unrecognized direction: '%s'", direction));
    }

    public static Directions convert(HugeType edgeType) {
        switch (edgeType) {
            case EDGE_OUT: {
                return OUT;
            }
            case EDGE_IN: {
                return IN;
            }
        }
        throw new IllegalArgumentException(String.format("Can't convert type '%s' to Direction", edgeType));
    }

    static {
        $VALUES = new Directions[]{BOTH, OUT, IN};
        SerialEnum.register(Directions.class);
    }
}

