/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.optimize;

import java.util.List;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.traversal.optimize.HugeVertexStep;
import org.apache.hugegraph.traversal.optimize.HugeVertexStepByBatch;
import org.apache.hugegraph.traversal.optimize.TraversalUtil;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PathStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TreeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.EmptyTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class HugeVertexStepStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final long serialVersionUID = 491355700217483162L;
    private static final HugeVertexStepStrategy INSTANCE = new HugeVertexStepStrategy();

    private HugeVertexStepStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        TraversalUtil.convAllHasSteps(traversal);
        List steps = TraversalHelper.getStepsOfClass(VertexStep.class, traversal);
        boolean batchOptimize = false;
        if (!steps.isEmpty()) {
            boolean withPath = HugeVertexStepStrategy.containsPath(traversal);
            boolean withTree = HugeVertexStepStrategy.containsTree(traversal);
            boolean supportIn = false;
            HugeGraph graph = TraversalUtil.tryGetGraph((Step)steps.get(0));
            if (graph != null) {
                supportIn = graph.backendStoreFeatures().supportsQueryWithInCondition();
            }
            batchOptimize = !withTree && !withPath && supportIn;
        }
        for (VertexStep originStep : steps) {
            HugeVertexStep newStep = batchOptimize ? new HugeVertexStepByBatch(originStep) : new HugeVertexStep(originStep);
            TraversalHelper.replaceStep((Step)originStep, newStep, traversal);
            TraversalUtil.extractHasContainer(newStep, traversal);
            TraversalUtil.extractRange(newStep, traversal, true);
            TraversalUtil.extractCount(newStep, traversal);
        }
    }

    protected static boolean containsPath(Traversal.Admin<?, ?> traversal) {
        boolean hasPath;
        boolean bl = hasPath = TraversalHelper.getStepsOfClass(PathStep.class, traversal).size() > 0;
        if (hasPath) {
            return true;
        }
        if (traversal instanceof EmptyTraversal) {
            return false;
        }
        TraversalParent parent = traversal.getParent();
        return HugeVertexStepStrategy.containsPath(parent.asStep().getTraversal());
    }

    protected static boolean containsTree(Traversal.Admin<?, ?> traversal) {
        boolean hasTree;
        boolean bl = hasTree = TraversalHelper.getStepsOfClass(TreeStep.class, traversal).size() > 0;
        if (hasTree) {
            return true;
        }
        if (traversal instanceof EmptyTraversal) {
            return false;
        }
        TraversalParent parent = traversal.getParent();
        return HugeVertexStepStrategy.containsTree(parent.asStep().getTraversal());
    }

    public static HugeVertexStepStrategy instance() {
        return INSTANCE;
    }
}

