/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.EdgeId;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.OltpTraverser;
import org.apache.hugegraph.traversal.algorithm.records.KoutRecords;
import org.apache.hugegraph.traversal.algorithm.steps.Steps;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class KoutTraverser
extends OltpTraverser {
    public KoutTraverser(HugeGraph graph) {
        super(graph);
    }

    public Set<Id> kout(Id sourceV, Directions dir, String label, int depth, boolean nearest, long degree, long capacity, long limit) {
        long remaining;
        E.checkNotNull((Object)sourceV, (String)"source vertex id");
        this.checkVertexExist(sourceV, "source vertex");
        E.checkNotNull((Object)dir, (String)"direction");
        KoutTraverser.checkPositive(depth, "k-out max_depth");
        KoutTraverser.checkDegree(degree);
        KoutTraverser.checkCapacity(capacity);
        KoutTraverser.checkLimit(limit);
        if (capacity != -1L) {
            E.checkArgument((capacity >= limit && limit != -1L ? 1 : 0) != 0, (String)"Capacity can't be less than limit, but got capacity '%s' and limit '%s'", (Object[])new Object[]{capacity, limit});
        }
        Id labelId = this.getEdgeLabelId(label);
        Set<Id> sources = KoutTraverser.newIdSet();
        Set<Id> neighbors = KoutTraverser.newIdSet();
        Set<Id> visited = nearest ? KoutTraverser.newIdSet() : null;
        neighbors.add(sourceV);
        long l = remaining = capacity == -1L ? -1L : capacity - 1L;
        while (depth-- > 0) {
            if (depth == 0 && limit != -1L && (limit < remaining || remaining == -1L)) {
                remaining = limit;
            }
            if (visited != null) {
                visited.addAll(neighbors);
            }
            Set<Id> tmp = neighbors;
            neighbors = sources;
            sources = tmp;
            OltpTraverser.ConcurrentVerticesConsumer consumer = new OltpTraverser.ConcurrentVerticesConsumer(sourceV, visited, remaining, neighbors);
            this.vertexIterCounter.addAndGet(sources.size());
            this.edgeIterCounter.addAndGet(neighbors.size());
            this.traverseIdsByBfs(sources.iterator(), dir, labelId, degree, capacity, consumer);
            sources.clear();
            if (capacity == -1L || (remaining -= (long)neighbors.size()) > 0L || depth <= 0) continue;
            throw new HugeException("Reach capacity '%s' while remaining depth '%s'", capacity, depth);
        }
        return neighbors;
    }

    public KoutRecords customizedKout(Id source, Steps steps, int maxDepth, boolean nearest, long capacity, long limit) {
        E.checkNotNull((Object)source, (String)"source vertex id");
        this.checkVertexExist(source, "source vertex");
        KoutTraverser.checkPositive(maxDepth, "k-out max_depth");
        KoutTraverser.checkCapacity(capacity);
        KoutTraverser.checkLimit(limit);
        long[] depth = new long[]{maxDepth};
        KoutRecords records = new KoutRecords(true, source, nearest, 0);
        Consumer<Edge> consumer = edge -> {
            if (this.reachLimit(limit, depth[0], records.size())) {
                return;
            }
            EdgeId edgeId = ((HugeEdge)edge).id();
            records.addPath(edgeId.ownerVertexId(), edgeId.otherVertexId());
            records.edgeResults().addEdge(edgeId.ownerVertexId(), edgeId.otherVertexId(), (Edge)edge);
        };
        while (true) {
            long l = depth[0];
            depth[0] = l - 1L;
            if (l <= 0L) break;
            List<Id> sources = records.ids(Long.MAX_VALUE);
            records.startOneLayer(true);
            this.traverseIdsByBfs(sources.iterator(), steps, capacity, consumer);
            this.vertexIterCounter.addAndGet(sources.size());
            records.finishOneLayer();
            this.checkCapacity(capacity, records.accessed(), depth[0]);
        }
        return records;
    }

    public KoutRecords dfsKout(Id source, Steps steps, int maxDepth, boolean nearest, long capacity, long limit) {
        E.checkNotNull((Object)source, (String)"source vertex id");
        this.checkVertexExist(source, "source vertex");
        KoutTraverser.checkPositive(maxDepth, "k-out max_depth");
        KoutTraverser.checkCapacity(capacity);
        KoutTraverser.checkLimit(limit);
        Set<Id> all = KoutTraverser.newIdSet();
        all.add(source);
        KoutRecords records = new KoutRecords(false, source, nearest, maxDepth);
        Iterator<Edge> iterator = this.createNestedIterator(source, steps, maxDepth, all, nearest);
        while (iterator.hasNext()) {
            HugeEdge edge = (HugeEdge)iterator.next();
            this.edgeIterCounter.addAndGet(1L);
            Id target = edge.id().otherVertexId();
            if (!nearest || !all.contains(target)) {
                records.addFullPath(HugeTraverser.pathEdges(iterator, edge));
            }
            if ((limit == -1L || (long)records.size() < limit) && (capacity == -1L || (long)all.size() <= capacity)) continue;
            break;
        }
        return records;
    }

    private void checkCapacity(long capacity, long accessed, long depth) {
        if (capacity == -1L) {
            return;
        }
        if (accessed >= capacity && depth > 0L) {
            throw new HugeException("Reach capacity '%s' while remaining depth '%s'", capacity, depth);
        }
    }

    private boolean reachLimit(long limit, long depth, int size) {
        return limit != -1L && depth <= 0L && (long)size >= limit;
    }
}

