/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.task;

import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.task.HugeTask;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.slf4j.Logger;

public abstract class TaskCallable<V>
implements Callable<V> {
    private static final Logger LOG = Log.logger(TaskCallable.class);
    private static final String ERROR_COMMIT = "Failed to commit changes: ";
    private static final Set<String> ERROR_MESSAGES = ImmutableSet.of((Object)"The max length of bytes is", (Object)"Batch too large");
    private HugeTask<V> task = null;
    private HugeGraph graph = null;
    private volatile long lastSaveTime = System.currentTimeMillis();
    private volatile long saveInterval = 30000L;

    protected void done() {
        this.closeTx();
    }

    protected void cancelled() {
    }

    protected void closeTx() {
        Transaction tx = this.graph().tx();
        if (tx.isOpen()) {
            tx.close();
        }
    }

    public void setMinSaveInterval(long seconds) {
        E.checkArgument((seconds > 0L ? 1 : 0) != 0, (String)"Must set interval > 0, but got '%s'", (Object[])new Object[]{seconds});
        this.saveInterval = seconds * 1000L;
    }

    public void updateProgress(int progress) {
        HugeTask<V> task = this.task();
        task.progress(progress);
        long elapse = System.currentTimeMillis() - this.lastSaveTime;
        if (elapse > this.saveInterval) {
            this.save();
            this.lastSaveTime = System.currentTimeMillis();
        }
    }

    public int progress() {
        HugeTask<V> task = this.task();
        return task.progress();
    }

    protected void save() {
        HugeTask<V> task = this.task();
        task.updateTime(new Date());
        try {
            this.graph().taskScheduler().save(task);
        }
        catch (Throwable e) {
            if (task.completed()) {
                LOG.error("Failed to save task with error \"{}\": {}", (Object)e, task.asMap(false));
                String message = e.getMessage();
                if (message.contains(ERROR_COMMIT) && TaskCallable.needSaveWithEx(message)) {
                    task.failToSave(e);
                    this.graph().taskScheduler().save(task);
                    return;
                }
            }
            throw e;
        }
    }

    protected void graph(HugeGraph graph) {
        this.graph = graph;
    }

    public HugeGraph graph() {
        E.checkState((this.graph != null ? 1 : 0) != 0, (String)"Can't call graph() before scheduling task", (Object[])new Object[0]);
        return this.graph;
    }

    protected void task(HugeTask<V> task) {
        this.task = task;
    }

    public HugeTask<V> task() {
        E.checkState((this.task != null ? 1 : 0) != 0, (String)"Can't call task() before scheduling task", (Object[])new Object[0]);
        return this.task;
    }

    public static <V> TaskCallable<V> fromClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (TaskCallable)clazz.newInstance();
        }
        catch (Exception e) {
            throw new HugeException("Failed to load task: %s", (Throwable)e, className);
        }
    }

    private static boolean needSaveWithEx(String message) {
        for (String error : ERROR_MESSAGES) {
            if (!message.contains(error)) continue;
            return true;
        }
        return false;
    }

    public static <V> TaskCallable<V> empty(final Exception e) {
        return new TaskCallable<V>(){

            @Override
            public V call() throws Exception {
                throw e;
            }
        };
    }

    public static abstract class SysTaskCallable<V>
    extends TaskCallable<V> {
        private HugeGraphParams params = null;

        protected void params(HugeGraphParams params) {
            this.params = params;
        }

        protected HugeGraphParams params() {
            E.checkState((this.params != null ? 1 : 0) != 0, (String)"Can't call scheduler() before scheduling task", (Object[])new Object[0]);
            return this.params;
        }
    }
}

