/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.masterelection;

import org.apache.hugegraph.config.ConfigOption;
import org.apache.hugegraph.config.OptionChecker;
import org.apache.hugegraph.config.OptionHolder;

public class RoleElectionOptions
extends OptionHolder {
    private static volatile RoleElectionOptions instance;
    public static final ConfigOption<Integer> EXCEEDS_FAIL_COUNT;
    public static final ConfigOption<String> NODE_EXTERNAL_URL;
    public static final ConfigOption<Integer> RANDOM_TIMEOUT_MILLISECOND;
    public static final ConfigOption<Integer> HEARTBEAT_INTERVAL_SECOND;
    public static final ConfigOption<Integer> MASTER_DEAD_TIMES;
    public static final ConfigOption<Integer> BASE_TIMEOUT_MILLISECOND;

    private RoleElectionOptions() {
    }

    public static synchronized RoleElectionOptions instance() {
        if (instance == null) {
            instance = new RoleElectionOptions();
            instance.registerOptions();
        }
        return instance;
    }

    static {
        EXCEEDS_FAIL_COUNT = new ConfigOption("server.role.fail_count", "When the node failed count of update or query heartbeat is reaches this threshold, the node will become abdication state to guardsafe property.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)5);
        NODE_EXTERNAL_URL = new ConfigOption("server.role.node_external_url", "The url of external accessibility.", OptionChecker.disallowEmpty(), (Object)"http://127.0.0.1:8080");
        RANDOM_TIMEOUT_MILLISECOND = new ConfigOption("server.role.random_timeout", "The random timeout in ms that be used when candidate node request to become master state to reduce competitive voting.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)1000);
        HEARTBEAT_INTERVAL_SECOND = new ConfigOption("server.role.heartbeat_interval", "The role state machine heartbeat interval second time.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)2);
        MASTER_DEAD_TIMES = new ConfigOption("server.role.master_dead_times", "When the worker node detects that the number of times the master node fails to update heartbeat reaches this threshold, the worker node will become to a candidate node.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)10);
        BASE_TIMEOUT_MILLISECOND = new ConfigOption("server.role.base_timeout", "The role state machine candidate state base timeout time.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)500);
    }
}

