/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.memory;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.LocalCounter;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.serializer.TextBackendEntry;
import org.apache.hugegraph.backend.store.AbstractBackendStore;
import org.apache.hugegraph.backend.store.BackendAction;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendFeatures;
import org.apache.hugegraph.backend.store.BackendMutation;
import org.apache.hugegraph.backend.store.BackendSession;
import org.apache.hugegraph.backend.store.BackendStoreProvider;
import org.apache.hugegraph.backend.store.memory.InMemoryDBTable;
import org.apache.hugegraph.backend.store.memory.InMemoryDBTables;
import org.apache.hugegraph.backend.store.memory.InMemoryMetrics;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public abstract class InMemoryDBStore
extends AbstractBackendStore<BackendSession> {
    private static final Logger LOG = Log.logger(InMemoryDBStore.class);
    private final BackendStoreProvider provider;
    private final String store;
    private final String database;
    private final Map<HugeType, InMemoryDBTable> tables;
    private static final BackendFeatures FEATURES = new BackendFeatures(){

        @Override
        public boolean supportsPersistence() {
            return false;
        }

        @Override
        public boolean supportsSharedStorage() {
            return false;
        }

        @Override
        public boolean supportsScanToken() {
            return false;
        }

        @Override
        public boolean supportsScanKeyPrefix() {
            return false;
        }

        @Override
        public boolean supportsScanKeyRange() {
            return false;
        }

        @Override
        public boolean supportsQuerySchemaByName() {
            return true;
        }

        @Override
        public boolean supportsQueryByLabel() {
            return true;
        }

        @Override
        public boolean supportsQueryWithInCondition() {
            return false;
        }

        @Override
        public boolean supportsQueryWithRangeCondition() {
            return true;
        }

        @Override
        public boolean supportsQueryWithOrderBy() {
            return false;
        }

        @Override
        public boolean supportsQueryWithContains() {
            return false;
        }

        @Override
        public boolean supportsQueryWithContainsKey() {
            return false;
        }

        @Override
        public boolean supportsQueryByPage() {
            return false;
        }

        @Override
        public boolean supportsQuerySortByInputIds() {
            return true;
        }

        @Override
        public boolean supportsDeleteEdgeByLabel() {
            return false;
        }

        @Override
        public boolean supportsUpdateVertexProperty() {
            return false;
        }

        @Override
        public boolean supportsMergeVertexProperty() {
            return false;
        }

        @Override
        public boolean supportsUpdateEdgeProperty() {
            return false;
        }

        @Override
        public boolean supportsTransaction() {
            return false;
        }

        @Override
        public boolean supportsNumberType() {
            return false;
        }

        @Override
        public boolean supportsAggregateProperty() {
            return false;
        }

        @Override
        public boolean supportsTtl() {
            return false;
        }

        @Override
        public boolean supportsOlapProperties() {
            return false;
        }
    };

    public InMemoryDBStore(BackendStoreProvider provider, String database, String store) {
        this.provider = provider;
        this.database = database;
        this.store = store;
        this.tables = new HashMap<HugeType, InMemoryDBTable>();
        this.registerMetaHandlers();
        LOG.debug("Store loaded: {}", (Object)store);
    }

    private void registerMetaHandlers() {
        this.registerMetaHandler("metrics", (session, meta, args) -> {
            InMemoryMetrics metrics = new InMemoryMetrics();
            return metrics.metrics();
        });
    }

    protected void registerTableManager(HugeType type, InMemoryDBTable table) {
        this.tables.put(type, table);
    }

    protected Collection<InMemoryDBTable> tables() {
        return this.tables.values();
    }

    protected final InMemoryDBTable table(HugeType type) {
        assert (type != null);
        InMemoryDBTable table = this.tables.get(type);
        if (table == null) {
            throw new BackendException("Unsupported table type: %s", type);
        }
        return table;
    }

    @Override
    protected BackendSession session(HugeType type) {
        return null;
    }

    @Override
    public Iterator<BackendEntry> query(Query query) {
        InMemoryDBTable table = this.table(InMemoryDBTable.tableType(query));
        Iterator<BackendEntry> rs = table.query(null, query);
        LOG.debug("[store {}] has result({}) for query: {}", new Object[]{this.store, rs.hasNext(), query});
        return rs;
    }

    @Override
    public Number queryNumber(Query query) {
        InMemoryDBTable table = this.table(InMemoryDBTable.tableType(query));
        Number result = table.queryNumber(null, query);
        LOG.debug("[store {}] get result({}) for number query: {}", new Object[]{this.store, result, query});
        return result;
    }

    @Override
    public void mutate(BackendMutation mutation) {
        Iterator<BackendAction> it = mutation.mutation();
        while (it.hasNext()) {
            this.mutate(it.next());
        }
    }

    protected void mutate(BackendAction item) {
        BackendEntry e = item.entry();
        assert (e instanceof TextBackendEntry);
        TextBackendEntry entry = (TextBackendEntry)e;
        InMemoryDBTable table = this.table(entry.type());
        switch (item.action()) {
            case INSERT: {
                LOG.debug("[store {}] add entry: {}", (Object)this.store, (Object)entry);
                table.insert((BackendSession)null, entry);
                break;
            }
            case DELETE: {
                LOG.debug("[store {}] remove id: {}", (Object)this.store, (Object)entry.id());
                table.delete((BackendSession)null, entry);
                break;
            }
            case APPEND: {
                LOG.debug("[store {}] append entry: {}", (Object)this.store, (Object)entry);
                table.append((BackendSession)null, entry);
                break;
            }
            case ELIMINATE: {
                LOG.debug("[store {}] eliminate entry: {}", (Object)this.store, (Object)entry);
                table.eliminate((BackendSession)null, entry);
                break;
            }
            case UPDATE_IF_PRESENT: {
                table.updateIfPresent(null, entry);
                break;
            }
            case UPDATE_IF_ABSENT: {
                table.updateIfAbsent(null, entry);
                break;
            }
            default: {
                throw new BackendException("Unsupported mutate type: %s", item.action());
            }
        }
    }

    @Override
    public String store() {
        return this.store;
    }

    @Override
    public String database() {
        return this.database;
    }

    @Override
    public BackendStoreProvider provider() {
        return this.provider;
    }

    @Override
    public void open(HugeConfig config) {
        LOG.debug("Store opened: {}", (Object)this.store);
    }

    @Override
    public void close() throws BackendException {
        LOG.debug("Store closed: {}", (Object)this.store);
    }

    @Override
    public void init() {
        for (InMemoryDBTable table : this.tables()) {
            table.init(null);
        }
        LOG.debug("Store initialized: {}", (Object)this.store);
    }

    @Override
    public void clear(boolean clearSpace) {
        for (InMemoryDBTable table : this.tables()) {
            table.clear(null);
        }
        LOG.debug("Store cleared: {}", (Object)this.store);
    }

    @Override
    public void truncate() {
        for (InMemoryDBTable table : this.tables()) {
            table.clear(null);
        }
        LOG.debug("Store truncated: {}", (Object)this.store);
    }

    @Override
    public void beginTx() {
    }

    @Override
    public void commitTx() {
    }

    @Override
    public void rollbackTx() {
        throw new UnsupportedOperationException("Unsupported rollback operation by InMemoryDBStore");
    }

    @Override
    public BackendFeatures features() {
        return FEATURES;
    }

    @Override
    public boolean opened() {
        return true;
    }

    @Override
    public boolean initialized() {
        return true;
    }

    public static class InMemorySystemStore
    extends InMemoryGraphStore {
        public InMemorySystemStore(BackendStoreProvider provider, String database, String store) {
            super(provider, database, store);
        }

        @Override
        public String storedVersion() {
            return this.provider().driverVersion();
        }
    }

    public static class InMemoryGraphStore
    extends InMemoryDBStore {
        public InMemoryGraphStore(BackendStoreProvider provider, String database, String store) {
            super(provider, database, store);
            this.registerTableManager(HugeType.VERTEX, new InMemoryDBTables.Vertex());
            this.registerTableManager(HugeType.EDGE_OUT, new InMemoryDBTables.Edge(HugeType.EDGE_OUT));
            this.registerTableManager(HugeType.EDGE_IN, new InMemoryDBTables.Edge(HugeType.EDGE_IN));
            this.registerTableManager(HugeType.SECONDARY_INDEX, new InMemoryDBTables.SecondaryIndex());
            this.registerTableManager(HugeType.RANGE_INT_INDEX, InMemoryDBTables.RangeIndex.rangeInt());
            this.registerTableManager(HugeType.RANGE_FLOAT_INDEX, InMemoryDBTables.RangeIndex.rangeFloat());
            this.registerTableManager(HugeType.RANGE_LONG_INDEX, InMemoryDBTables.RangeIndex.rangeLong());
            this.registerTableManager(HugeType.RANGE_DOUBLE_INDEX, InMemoryDBTables.RangeIndex.rangeDouble());
            this.registerTableManager(HugeType.SEARCH_INDEX, new InMemoryDBTables.SearchIndex());
            this.registerTableManager(HugeType.SHARD_INDEX, new InMemoryDBTables.ShardIndex());
            this.registerTableManager(HugeType.UNIQUE_INDEX, new InMemoryDBTables.UniqueIndex());
        }

        @Override
        public boolean isSchemaStore() {
            return false;
        }

        @Override
        public Id nextId(HugeType type) {
            throw new UnsupportedOperationException("InMemoryGraphStore.nextId()");
        }

        @Override
        public void increaseCounter(HugeType type, long num) {
            throw new UnsupportedOperationException("InMemoryGraphStore.increaseCounter()");
        }

        @Override
        public long getCounter(HugeType type) {
            throw new UnsupportedOperationException("InMemoryGraphStore.getCounter()");
        }
    }

    public static class InMemorySchemaStore
    extends InMemoryDBStore {
        private final LocalCounter counter = new LocalCounter();

        public InMemorySchemaStore(BackendStoreProvider provider, String database, String store) {
            super(provider, database, store);
            this.registerTableManager(HugeType.VERTEX_LABEL, new InMemoryDBTable(HugeType.VERTEX_LABEL));
            this.registerTableManager(HugeType.EDGE_LABEL, new InMemoryDBTable(HugeType.EDGE_LABEL));
            this.registerTableManager(HugeType.PROPERTY_KEY, new InMemoryDBTable(HugeType.PROPERTY_KEY));
            this.registerTableManager(HugeType.INDEX_LABEL, new InMemoryDBTable(HugeType.INDEX_LABEL));
            this.registerTableManager(HugeType.SECONDARY_INDEX, new InMemoryDBTables.SecondaryIndex());
        }

        @Override
        public Id nextId(HugeType type) {
            return this.counter.nextId(type);
        }

        @Override
        public void increaseCounter(HugeType type, long increment) {
            this.counter.increaseCounter(type, increment);
        }

        @Override
        public long getCounter(HugeType type) {
            return this.counter.getCounter(type);
        }

        @Override
        public void clear(boolean clearSpace) {
            this.counter.reset();
            super.clear(clearSpace);
        }

        @Override
        public void truncate() {
            this.counter.reset();
            super.truncate();
        }

        @Override
        public boolean isSchemaStore() {
            return true;
        }
    }
}

