/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.protocol;

import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoader;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.ext.ExtensionLoaderListener;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.protocol.Protocol;
import com.alipay.sofa.rpc.protocol.ProtocolInfo;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ProtocolFactory {
    private static final ConcurrentMap<Byte, Protocol> TYPE_PROTOCOL_MAP = new ConcurrentHashMap<Byte, Protocol>();
    private static final ConcurrentMap<String, Byte> TYPE_CODE_MAP = new ConcurrentHashMap<String, Byte>();
    private static final ExtensionLoader<Protocol> EXTENSION_LOADER = ProtocolFactory.buildLoader();
    private static int maxMagicOffset;

    private static ExtensionLoader<Protocol> buildLoader() {
        ExtensionLoader<Protocol> extensionLoader = ExtensionLoaderFactory.getExtensionLoader(Protocol.class);
        extensionLoader.addListener(new ExtensionLoaderListener<Protocol>(){

            @Override
            public void onLoad(ExtensionClass<Protocol> extensionClass) {
                Protocol protocol = extensionClass.getExtInstance();
                TYPE_PROTOCOL_MAP.put(extensionClass.getCode(), protocol);
                TYPE_CODE_MAP.put(extensionClass.getAlias(), extensionClass.getCode());
                if (RpcConfigs.getBooleanValue("transport.server.protocol.adaptive")) {
                    maxMagicOffset = 2;
                    ProtocolFactory.registerAdaptiveProtocol(protocol.protocolInfo());
                }
            }
        });
        return extensionLoader;
    }

    public static Protocol getProtocol(String alias) {
        return EXTENSION_LOADER.getExtension(alias);
    }

    public static Protocol getProtocol(byte code) {
        Protocol protocol = (Protocol)TYPE_PROTOCOL_MAP.get(code);
        if (protocol == null) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("020110001", code));
        }
        return protocol;
    }

    public static Byte getCodeByAlias(String protocol) {
        return (Byte)TYPE_CODE_MAP.get(protocol);
    }

    public static Protocol adaptiveProtocol(byte[] magicHeadBytes) {
        for (Protocol protocol : TYPE_PROTOCOL_MAP.values()) {
            if (!protocol.protocolInfo().isMatchMagic(magicHeadBytes)) continue;
            return protocol;
        }
        return null;
    }

    protected static synchronized void registerAdaptiveProtocol(ProtocolInfo protocolInfo) {
        maxMagicOffset = Math.max(maxMagicOffset, protocolInfo.magicFieldOffset() + protocolInfo.magicFieldLength());
    }

    public static int getMaxMagicOffset() {
        return maxMagicOffset;
    }
}

