/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.context;

import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.util.Map;

public class BaggageResolver {
    public static final Logger LOGGER = LoggerFactory.getLogger(BaggageResolver.class);

    public static void carryWithRequest(RpcInvokeContext context, SofaRequest request) {
        Map<String, String> requestBaggage;
        if (context != null && CommonUtils.isNotEmpty(requestBaggage = context.getAllRequestBaggage())) {
            request.addRequestProp("rpc_req_baggage", requestBaggage);
        }
    }

    public static void pickupFromRequest(RpcInvokeContext context, SofaRequest request, boolean init) {
        if (context == null && !init) {
            return;
        }
        Map requestBaggage = (Map)request.getRequestProp("rpc_req_baggage");
        if (CommonUtils.isNotEmpty(requestBaggage)) {
            if (context == null) {
                context = RpcInvokeContext.getContext();
            }
            context.putAllRequestBaggage(requestBaggage);
        }
    }

    public static void pickupFromRequest(RpcInvokeContext context, SofaRequest request) {
        BaggageResolver.pickupFromRequest(context, request, false);
    }

    public static void carryWithResponse(RpcInvokeContext context, SofaResponse response) {
        Map<String, String> responseBaggage;
        if (context != null && CommonUtils.isNotEmpty(responseBaggage = context.getAllResponseBaggage())) {
            String prefix = "rpc_resp_baggage.";
            for (Map.Entry<String, String> entry : responseBaggage.entrySet()) {
                response.addResponseProp(prefix + entry.getKey(), entry.getValue());
            }
        }
    }

    public static void pickupFromResponse(RpcInvokeContext context, SofaResponse response, boolean init) {
        if (context == null && !init) {
            return;
        }
        Map<String, String> responseBaggage = response.getResponseProps();
        if (CommonUtils.isNotEmpty(responseBaggage)) {
            String prefix = "rpc_resp_baggage.";
            for (Map.Entry<String, String> entry : responseBaggage.entrySet()) {
                if (!entry.getKey().startsWith(prefix)) continue;
                if (context == null) {
                    context = RpcInvokeContext.getContext();
                }
                context.putResponseBaggage(entry.getKey().substring(prefix.length()), entry.getValue());
            }
        }
    }

    public static void pickupFromResponse(RpcInvokeContext context, SofaResponse response) {
        BaggageResolver.pickupFromResponse(context, response, false);
    }
}

