/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.cassandra;

import org.apache.hugegraph.config.ConfigListOption;
import org.apache.hugegraph.config.ConfigOption;
import org.apache.hugegraph.config.OptionChecker;
import org.apache.hugegraph.config.OptionHolder;

public class CassandraOptions
extends OptionHolder {
    private static volatile CassandraOptions instance;
    public static final ConfigOption<String> CASSANDRA_HOST;
    public static final ConfigOption<Integer> CASSANDRA_PORT;
    public static final ConfigOption<String> CASSANDRA_USERNAME;
    public static final ConfigOption<String> CASSANDRA_PASSWORD;
    public static final ConfigOption<Integer> CASSANDRA_CONN_TIMEOUT;
    public static final ConfigOption<Integer> CASSANDRA_READ_TIMEOUT;
    public static final ConfigOption<String> CASSANDRA_STRATEGY;
    public static final ConfigListOption<String> CASSANDRA_REPLICATION;
    public static final ConfigOption<String> CASSANDRA_COMPRESSION;
    public static final ConfigOption<Integer> CASSANDRA_JMX_PORT;
    public static final ConfigOption<Integer> AGGR_TIMEOUT;

    private CassandraOptions() {
    }

    public static synchronized CassandraOptions instance() {
        if (instance == null) {
            instance = new CassandraOptions();
            instance.registerOptions();
        }
        return instance;
    }

    static {
        CASSANDRA_HOST = new ConfigOption("cassandra.host", "The seeds hostname or ip address of cassandra cluster.", OptionChecker.disallowEmpty(), (Object)"localhost");
        CASSANDRA_PORT = new ConfigOption("cassandra.port", "The seeds port address of cassandra cluster.", OptionChecker.rangeInt((Number)1, (Number)65535), (Object)9042);
        CASSANDRA_USERNAME = new ConfigOption("cassandra.username", "The username to use to login to cassandra cluster.", (Object)"");
        CASSANDRA_PASSWORD = new ConfigOption("cassandra.password", "The password corresponding to cassandra.username.", (Object)"");
        CASSANDRA_CONN_TIMEOUT = new ConfigOption("cassandra.connect_timeout", "The cassandra driver connect server timeout(seconds).", OptionChecker.rangeInt((Number)1, (Number)30), (Object)5);
        CASSANDRA_READ_TIMEOUT = new ConfigOption("cassandra.read_timeout", "The cassandra driver read from server timeout(seconds).", OptionChecker.rangeInt((Number)1, (Number)120), (Object)20);
        CASSANDRA_STRATEGY = new ConfigOption("cassandra.keyspace.strategy", "The replication strategy of keyspace, valid value is SimpleStrategy or NetworkTopologyStrategy.", OptionChecker.allowValues((Object[])new String[]{"SimpleStrategy", "NetworkTopologyStrategy"}), (Object)"SimpleStrategy");
        CASSANDRA_REPLICATION = new ConfigListOption("cassandra.keyspace.replication", "The keyspace replication factor of SimpleStrategy, like '[3]'. Or replicas in each datacenter of NetworkTopologyStrategy, like '[dc1:2,dc2:1]'.", OptionChecker.disallowEmpty(), (Object[])new String[]{"3"});
        CASSANDRA_COMPRESSION = new ConfigOption("cassandra.compression_type", "The compression algorithm of cassandra transport: none/snappy/lz4.", OptionChecker.allowValues((Object[])new String[]{"none", "snappy", "lz4"}), (Object)"none");
        CASSANDRA_JMX_PORT = new ConfigOption("cassandra.jmx_port", "The port of JMX API service for cassandra", OptionChecker.rangeInt((Number)1, (Number)65535), (Object)7199);
        AGGR_TIMEOUT = new ConfigOption("cassandra.aggregation_timeout", "The timeout in seconds of waiting for aggregation.", OptionChecker.positiveInt(), (Object)43200);
    }
}

