/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.cassandra;

import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.PagingState;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.hugegraph.backend.page.PageState;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendEntryIterator;
import org.apache.hugegraph.backend.store.cassandra.CassandraBackendEntry;
import org.apache.hugegraph.util.E;

public class CassandraEntryIterator
extends BackendEntryIterator {
    private final ResultSet results;
    private final Iterator<Row> rows;
    private final BiFunction<BackendEntry, Row, BackendEntry> merger;
    private int fetchedPageSize;
    private long expected;
    private BackendEntry next;

    public CassandraEntryIterator(ResultSet results, Query query, BiFunction<BackendEntry, Row, BackendEntry> merger) {
        super(query);
        this.results = results;
        this.rows = results.iterator();
        this.merger = merger;
        this.fetchedPageSize = results.getAvailableWithoutFetching();
        this.next = null;
        if (query.paging()) {
            assert (query.offset() == 0L);
            assert (query.limit() >= 0L || query.noLimit()) : query.limit();
            this.expected = PageState.fromString((String)query.page()).offset();
            this.skipPageOffset(query.page());
            E.checkState(((long)this.fetchedPageSize <= query.limit() ? 1 : 0) != 0, (String)"Unexpected fetched page size: %s", (Object[])new Object[]{this.fetchedPageSize});
            this.expected = results.isFullyFetched() ? (long)this.fetchedPageSize : query.total();
        } else {
            this.expected = query.total();
            this.skipOffset();
        }
    }

    public void close() throws Exception {
    }

    protected final boolean fetch() {
        assert (this.current == null);
        if (this.next != null) {
            this.current = this.next;
            this.next = null;
        }
        while (this.expected > 0L && this.rows.hasNext()) {
            --this.expected;
            Row row = this.rows.next();
            if (this.query.paging() && this.expected > 0L && this.availableLocal() == 0 && this.rows.hasNext()) {
                this.fetchedPageSize = this.availableLocal();
            }
            BackendEntry merged = this.merger.apply(this.current, row);
            if (this.current == null) {
                this.current = merged;
                continue;
            }
            if (merged == this.current) {
                assert (merged != null);
                continue;
            }
            assert (this.next == null);
            this.next = merged;
            break;
        }
        return this.current != null;
    }

    protected final long sizeOf(BackendEntry entry) {
        CassandraBackendEntry e = (CassandraBackendEntry)entry;
        int subRowsSize = e.subRows().size();
        return subRowsSize > 0 ? (long)subRowsSize : 1L;
    }

    protected final long skip(BackendEntry entry, long skip) {
        CassandraBackendEntry e = (CassandraBackendEntry)entry;
        E.checkState(((long)e.subRows().size() > skip ? 1 : 0) != 0, (String)"Invalid entry to skip", (Object[])new Object[0]);
        for (long i = 0L; i < skip; ++i) {
            e.subRows().remove(0);
        }
        return e.subRows().size();
    }

    protected PageState pageState() {
        byte[] position;
        int offset = 0;
        int count = (int)this.count();
        assert (this.fetched() == (long)count);
        int extra = this.availableLocal();
        List infos = this.results.getAllExecutionInfo();
        if (extra > 0 && infos.size() >= 2) {
            ExecutionInfo previous = (ExecutionInfo)infos.get(infos.size() - 2);
            PagingState page = previous.getPagingState();
            position = page.toBytes();
            offset = this.fetchedPageSize - extra;
        } else {
            PagingState page = this.results.getExecutionInfo().getPagingState();
            if (page == null || this.expected > 0L) {
                E.checkState((boolean)this.results.isExhausted(), (String)"Unexpected paging state with expected=%s, ensure consume all the fetched results before calling pageState()", (Object[])new Object[]{this.expected});
                position = PageState.EMPTY_BYTES;
            } else {
                position = page.toBytes();
            }
        }
        return new PageState(position, offset, count);
    }

    private int availableLocal() {
        return this.results.getAvailableWithoutFetching();
    }
}

