/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import java.io.Console;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.auth.AuthManager;
import org.apache.hugegraph.auth.HugeAuthenticator;
import org.apache.hugegraph.auth.HugeUser;
import org.apache.hugegraph.auth.RolePermission;
import org.apache.hugegraph.auth.StandardAuthManager;
import org.apache.hugegraph.auth.UserWithRole;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.masterelection.RoleElectionOptions;
import org.apache.hugegraph.rpc.RpcClientProviderWithAuth;
import org.apache.hugegraph.util.ConfigUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.StringEncoding;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticationException;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;

public class StandardAuthenticator
implements HugeAuthenticator {
    private static final String INITING_STORE = "initing_store";
    private HugeGraph graph = null;

    private void initAdminUser() throws Exception {
        if (this.requireInitAdminUser()) {
            this.initAdminUser(this.inputPassword());
        }
        this.graph.close();
    }

    @Override
    public HugeGraph graph() {
        E.checkState((this.graph != null ? 1 : 0) != 0, (String)"Must setup Authenticator first", (Object[])new Object[0]);
        return this.graph;
    }

    @Override
    public void initAdminUser(String password) {
        String caller = Thread.currentThread().getName();
        E.checkState((boolean)"main".equals(caller), (String)"Invalid caller '%s'", (Object[])new Object[]{caller});
        AuthManager authManager = this.graph().hugegraph().authManager();
        if (this.requireInitAdminUser()) {
            HugeUser admin = new HugeUser("admin");
            admin.password(StringEncoding.hashPassword((String)password));
            admin.creator("system");
            authManager.createUser(admin);
        }
    }

    private boolean requireInitAdminUser() {
        AuthManager authManager = this.graph().hugegraph().authManager();
        return StandardAuthManager.isLocal((AuthManager)authManager) && authManager.findUser("admin") == null;
    }

    private String inputPassword() {
        String inputPrompt = "Please input the admin password:";
        String notEmptyPrompt = "The admin password can't be empty";
        Console console = System.console();
        while (true) {
            String password;
            if (console != null) {
                char[] chars = console.readPassword(inputPrompt, new Object[0]);
                password = new String(chars);
            } else {
                System.out.println(inputPrompt);
                Scanner scanner = new Scanner(System.in);
                password = scanner.nextLine();
            }
            if (!password.isEmpty()) {
                return password;
            }
            System.out.println(notEmptyPrompt);
        }
    }

    @Override
    public void setup(HugeConfig config) {
        String graphName = (String)config.get(ServerOptions.AUTH_GRAPH_STORE);
        Map graphConfs = ConfigUtil.scanGraphsDir((String)((String)config.get(ServerOptions.GRAPHS)));
        String graphPath = (String)graphConfs.get(graphName);
        E.checkArgument((graphPath != null ? 1 : 0) != 0, (String)"Can't find graph name '%s' in config '%s' at 'rest-server.properties' to store auth information, please ensure the value of '%s' matches it correctly", (Object[])new Object[]{graphName, ServerOptions.GRAPHS, ServerOptions.AUTH_GRAPH_STORE.name()});
        HugeConfig graphConfig = new HugeConfig(graphPath);
        if (config.getProperty(INITING_STORE) != null && config.getBoolean(INITING_STORE)) {
            graphConfig.setProperty(CoreOptions.RAFT_MODE.name(), (Object)"false");
        }
        String raftGroupPeers = (String)config.get(ServerOptions.RAFT_GROUP_PEERS);
        graphConfig.addProperty(ServerOptions.RAFT_GROUP_PEERS.name(), (Object)raftGroupPeers);
        this.transferRoleWorkerConfig(graphConfig, config);
        this.graph = (HugeGraph)GraphFactory.open((Configuration)graphConfig);
        String remoteUrl = (String)config.get(ServerOptions.AUTH_REMOTE_URL);
        if (StringUtils.isNotEmpty((String)remoteUrl)) {
            RpcClientProviderWithAuth clientProvider = new RpcClientProviderWithAuth(config);
            this.graph.switchAuthManager(clientProvider.authManager());
        }
    }

    private void transferRoleWorkerConfig(HugeConfig graphConfig, HugeConfig config) {
        graphConfig.addProperty(RoleElectionOptions.NODE_EXTERNAL_URL.name(), config.get(ServerOptions.REST_SERVER_URL));
        graphConfig.addProperty(RoleElectionOptions.BASE_TIMEOUT_MILLISECOND.name(), config.get((TypedOption)RoleElectionOptions.BASE_TIMEOUT_MILLISECOND));
        graphConfig.addProperty(RoleElectionOptions.EXCEEDS_FAIL_COUNT.name(), config.get((TypedOption)RoleElectionOptions.EXCEEDS_FAIL_COUNT));
        graphConfig.addProperty(RoleElectionOptions.RANDOM_TIMEOUT_MILLISECOND.name(), config.get((TypedOption)RoleElectionOptions.RANDOM_TIMEOUT_MILLISECOND));
        graphConfig.addProperty(RoleElectionOptions.HEARTBEAT_INTERVAL_SECOND.name(), config.get((TypedOption)RoleElectionOptions.HEARTBEAT_INTERVAL_SECOND));
        graphConfig.addProperty(RoleElectionOptions.MASTER_DEAD_TIMES.name(), config.get((TypedOption)RoleElectionOptions.MASTER_DEAD_TIMES));
    }

    @Override
    public UserWithRole authenticate(String username, String password, String token) {
        UserWithRole userWithRole;
        if (StringUtils.isNotEmpty((String)token)) {
            userWithRole = this.authManager().validateUser(token);
        } else {
            E.checkArgumentNotNull((Object)username, (String)"The username parameter can't be null", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)password, (String)"The password parameter can't be null", (Object[])new Object[0]);
            userWithRole = this.authManager().validateUser(username, password);
        }
        RolePermission role = userWithRole.role();
        if (role == null) {
            role = ROLE_NONE;
        } else if ("admin".equals(userWithRole.username())) {
            role = ROLE_ADMIN;
        } else {
            return userWithRole;
        }
        return new UserWithRole(userWithRole.userId(), userWithRole.username(), role);
    }

    @Override
    public AuthManager authManager() {
        return this.graph().authManager();
    }

    public Authenticator.SaslNegotiator newSaslNegotiator(InetAddress remoteAddress) {
        return new TokenSaslAuthenticator();
    }

    public static void initAdminUserIfNeeded(String confFile) throws Exception {
        StandardAuthenticator auth = new StandardAuthenticator();
        HugeConfig config = new HugeConfig(confFile);
        String authClass = (String)config.get(ServerOptions.AUTHENTICATOR);
        if (authClass.isEmpty()) {
            return;
        }
        config.addProperty(INITING_STORE, (Object)true);
        auth.setup(config);
        if (auth.graph().backendStoreFeatures().supportsPersistence()) {
            auth.initAdminUser();
        }
    }

    private class TokenSaslAuthenticator
    implements Authenticator.SaslNegotiator {
        private static final byte NUL = 0;
        private String username;
        private String password;
        private String token;

        private TokenSaslAuthenticator() {
        }

        public byte[] evaluateResponse(byte[] clientResponse) throws AuthenticationException {
            this.decode(clientResponse);
            return null;
        }

        public boolean isComplete() {
            return this.username != null;
        }

        public AuthenticatedUser getAuthenticatedUser() throws AuthenticationException {
            if (!this.isComplete()) {
                throw new AuthenticationException("The SASL negotiation has not yet been completed.");
            }
            HashMap<String, String> credentials = new HashMap<String, String>(6, 1.0f);
            credentials.put("username", this.username);
            credentials.put("password", this.password);
            credentials.put("token", this.token);
            return StandardAuthenticator.this.authenticate(credentials);
        }

        private void decode(byte[] bytes) throws AuthenticationException {
            this.username = null;
            this.password = null;
            int end = bytes.length;
            for (int i = bytes.length - 1; i >= 0; --i) {
                if (bytes[i] != 0) continue;
                if (this.password == null) {
                    this.password = new String(Arrays.copyOfRange(bytes, i + 1, end), StandardCharsets.UTF_8);
                } else if (this.username == null) {
                    this.username = new String(Arrays.copyOfRange(bytes, i + 1, end), StandardCharsets.UTF_8);
                }
                end = i;
            }
            if (this.username == null) {
                throw new AuthenticationException("SASL authentication ID must not be null.");
            }
            if (this.password == null) {
                throw new AuthenticationException("SASL password must not be null.");
            }
            if (this.password.isEmpty()) {
                this.token = this.username;
            }
        }
    }
}

