/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Script;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalOptionParent;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.function.Lambda;

public interface Translator<S, T> {
    public S getTraversalSource();

    public T translate(Bytecode var1);

    default public T translate(Traversal<?, ?> t) {
        return this.translate(t.asAdmin().getBytecode());
    }

    public String getTargetLanguage();

    public static interface StepTranslator<S extends TraversalSource, T extends Traversal.Admin<?, ?>>
    extends Translator<S, T> {
    }

    public static interface ScriptTranslator
    extends Translator<String, Script> {

        public static abstract class AbstractTypeTranslator
        implements TypeTranslator {
            protected static final String ANONYMOUS_TRAVERSAL_PREFIX = "__";
            protected final boolean withParameters;
            protected final Script script;

            protected AbstractTypeTranslator(boolean withParameters) {
                this.withParameters = withParameters;
                this.script = new Script();
            }

            @Override
            public Script apply(String traversalSource, Object o) {
                this.script.init();
                if (o instanceof Bytecode) {
                    return this.produceScript(traversalSource, (Bytecode)o);
                }
                return this.convertToScript(o);
            }

            protected String getAnonymousTraversalPrefix() {
                return ANONYMOUS_TRAVERSAL_PREFIX;
            }

            protected abstract String getNullSyntax();

            protected abstract String getSyntax(String var1);

            protected abstract String getSyntax(Boolean var1);

            protected abstract String getSyntax(Date var1);

            protected abstract String getSyntax(Timestamp var1);

            protected abstract String getSyntax(UUID var1);

            protected abstract String getSyntax(Lambda var1);

            protected abstract String getSyntax(SackFunctions.Barrier var1);

            protected abstract String getSyntax(VertexProperty.Cardinality var1);

            protected abstract String getSyntax(TraversalOptionParent.Pick var1);

            protected abstract String getSyntax(Number var1);

            protected abstract Script produceScript(Set<?> var1);

            protected abstract Script produceScript(List<?> var1);

            protected abstract Script produceScript(Map<?, ?> var1);

            protected abstract Script produceScript(Class<?> var1);

            protected abstract Script produceScript(Enum<?> var1);

            protected abstract Script produceScript(Vertex var1);

            protected abstract Script produceScript(Edge var1);

            protected abstract Script produceScript(VertexProperty<?> var1);

            protected abstract Script produceScript(TraversalStrategyProxy<?> var1);

            protected abstract Script produceScript(String var1, Bytecode var2);

            protected abstract Script produceScript(P<?> var1);

            protected Script convertToScript(Object object) {
                if (object instanceof Bytecode.Binding) {
                    return this.script.getBoundKeyOrAssign(this.withParameters, ((Bytecode.Binding)object).variable());
                }
                if (object instanceof Bytecode) {
                    return this.produceScript(this.getAnonymousTraversalPrefix(), (Bytecode)object);
                }
                if (object instanceof Traversal) {
                    return this.convertToScript(((Traversal)object).asAdmin().getBytecode());
                }
                if (object instanceof String) {
                    Object objectOrWrapper = this.withParameters ? object : this.getSyntax((String)object);
                    return this.script.getBoundKeyOrAssign(this.withParameters, objectOrWrapper);
                }
                if (object instanceof Boolean) {
                    Object objectOrWrapper = this.withParameters ? object : this.getSyntax((Boolean)object);
                    return this.script.getBoundKeyOrAssign(this.withParameters, objectOrWrapper);
                }
                if (object instanceof Set) {
                    return this.produceScript((Set)object);
                }
                if (object instanceof List) {
                    return this.produceScript((List)object);
                }
                if (object instanceof Map) {
                    return this.produceScript((Map)object);
                }
                if (object instanceof Number) {
                    Object objectOrWrapper = this.withParameters ? object : this.getSyntax((Number)object);
                    return this.script.getBoundKeyOrAssign(this.withParameters, objectOrWrapper);
                }
                if (object instanceof Class) {
                    return this.produceScript((Class)object);
                }
                if (object instanceof Timestamp) {
                    Object objectOrWrapper = this.withParameters ? object : this.getSyntax((Timestamp)object);
                    return this.script.getBoundKeyOrAssign(this.withParameters, objectOrWrapper);
                }
                if (object instanceof Date) {
                    Object objectOrWrapper = this.withParameters ? object : this.getSyntax((Date)object);
                    return this.script.getBoundKeyOrAssign(this.withParameters, objectOrWrapper);
                }
                if (object instanceof UUID) {
                    Object objectOrWrapper = this.withParameters ? object : this.getSyntax((UUID)object);
                    return this.script.getBoundKeyOrAssign(this.withParameters, objectOrWrapper);
                }
                if (object instanceof P) {
                    return this.produceScript((P)object);
                }
                if (object instanceof SackFunctions.Barrier) {
                    return this.script.append(this.getSyntax((SackFunctions.Barrier)object));
                }
                if (object instanceof VertexProperty.Cardinality) {
                    return this.script.append(this.getSyntax((VertexProperty.Cardinality)((Object)object)));
                }
                if (object instanceof TraversalOptionParent.Pick) {
                    return this.script.append(this.getSyntax((TraversalOptionParent.Pick)((Object)object)));
                }
                if (object instanceof Enum) {
                    return this.produceScript((Enum)object);
                }
                if (object instanceof Vertex) {
                    return this.produceScript((Vertex)object);
                }
                if (object instanceof Edge) {
                    return this.produceScript((Edge)object);
                }
                if (object instanceof VertexProperty) {
                    return this.produceScript((VertexProperty)object);
                }
                if (object instanceof Lambda) {
                    Object objectOrWrapper = this.withParameters ? object : this.getSyntax((Lambda)object);
                    return this.script.getBoundKeyOrAssign(this.withParameters, objectOrWrapper);
                }
                if (object instanceof TraversalStrategyProxy) {
                    return this.produceScript((TraversalStrategyProxy)object);
                }
                if (object instanceof TraversalStrategy) {
                    return this.convertToScript(new TraversalStrategyProxy<TraversalStrategy>((TraversalStrategy)object));
                }
                return null == object ? this.script.append(this.getNullSyntax()) : this.script.getBoundKeyOrAssign(this.withParameters, object);
            }
        }

        public static interface TypeTranslator
        extends BiFunction<String, Object, Script> {
        }
    }
}

