/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.perceptron.structures;

import java.util.ArrayList;

public class Sentence
implements Comparable {
    private int[] words;
    private int[] tags;
    private int[] brownCluster4thPrefix;
    private int[] brownCluster6thPrefix;
    private int[] brownClusterFullString;

    public Sentence(ArrayList<Integer> tokens, ArrayList<Integer> pos, ArrayList<Integer> brownCluster4thPrefix, ArrayList<Integer> brownCluster6thPrefix, ArrayList<Integer> brownClusterFullString) {
        this.words = new int[tokens.size()];
        this.tags = new int[tokens.size()];
        this.brownCluster4thPrefix = new int[tokens.size()];
        this.brownCluster6thPrefix = new int[tokens.size()];
        this.brownClusterFullString = new int[tokens.size()];
        for (int i = 0; i < tokens.size(); ++i) {
            this.words[i] = tokens.get(i);
            this.tags[i] = pos.get(i);
            this.brownCluster4thPrefix[i] = brownCluster4thPrefix.get(i);
            this.brownCluster6thPrefix[i] = brownCluster6thPrefix.get(i);
            this.brownClusterFullString[i] = brownClusterFullString.get(i);
        }
    }

    public int size() {
        return this.words.length;
    }

    public int posAt(int position) {
        if (position == 0) {
            return 0;
        }
        return this.tags[position - 1];
    }

    public int[] getWords() {
        return this.words;
    }

    public int[] getTags() {
        return this.tags;
    }

    public int[] getBrownCluster4thPrefix() {
        return this.brownCluster4thPrefix;
    }

    public int[] getBrownCluster6thPrefix() {
        return this.brownCluster6thPrefix;
    }

    public int[] getBrownClusterFullString() {
        return this.brownClusterFullString;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Sentence) {
            Sentence sentence = (Sentence)obj;
            if (sentence.words.length != this.words.length) {
                return false;
            }
            for (int i = 0; i < sentence.words.length; ++i) {
                if (sentence.words[i] != this.words[i]) {
                    return false;
                }
                if (sentence.tags[i] == this.tags[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.hashCode() - o.hashCode();
    }

    public int hashCode() {
        int hash = 0;
        for (int tokenId = 0; tokenId < this.words.length; ++tokenId) {
            hash ^= this.words[tokenId] * this.tags[tokenId];
        }
        return hash;
    }
}

