/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package org.apache.hugegraph.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

import com.google.common.base.Stopwatch;

/**
 * This class is used for fixed watch-window to rate limit request
 * Now just simplify for performance, don't need lock stop watch
 *
 * Note: This class is not thread safe
 * TODO: Move to common module
 * */
public class FixedWatchWindowRateLimiter implements RateLimiter {

    private final LongAdder count;
    private final Stopwatch watch;
    private final int limit;

    public FixedWatchWindowRateLimiter(int limitPerSecond) {
        this.limit = limitPerSecond;
        this.watch = Stopwatch.createStarted();
        this.count = new LongAdder();
    }

    @Override
    public boolean tryAcquire() {
        if (count.intValue() < limit) {
            count.increment();
            return true;
        }

        // Reset only if 1000ms elapsed
        if (watch.elapsed(TimeUnit.MILLISECONDS) >= RESET_PERIOD) {
            count.reset();
            watch.reset();
            count.increment();
            return true;
        }
        return false;
    }
}
