/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.traverser;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.structure.traverser.EdgeStep;
import org.apache.hugegraph.structure.traverser.VerticesArgs;
import org.apache.hugegraph.util.E;

public class PathsRequest {
    @JsonProperty(value="sources")
    private VerticesArgs sources;
    @JsonProperty(value="targets")
    private VerticesArgs targets;
    @JsonProperty(value="step")
    public EdgeStep step;
    @JsonProperty(value="max_depth")
    public int depth;
    @JsonProperty(value="nearest")
    public boolean nearest = false;
    @JsonProperty(value="capacity")
    public long capacity = 10000000L;
    @JsonProperty(value="limit")
    public int limit = 100;
    @JsonProperty(value="with_vertex")
    public boolean withVertex = false;

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("PathRequest{sources=%s,targets=%s,step=%s,maxDepth=%s,nearest=%s,capacity=%s,limit=%s,withVertex=%s}", this.sources, this.targets, this.step, this.depth, this.nearest, this.capacity, this.limit, this.withVertex);
    }

    public static class Builder {
        private PathsRequest request = new PathsRequest();
        private EdgeStep.Builder stepBuilder = EdgeStep.builder();
        private VerticesArgs.Builder sourcesBuilder = VerticesArgs.builder();
        private VerticesArgs.Builder targetsBuilder = VerticesArgs.builder();

        private Builder() {
        }

        public VerticesArgs.Builder sources() {
            return this.sourcesBuilder;
        }

        public VerticesArgs.Builder targets() {
            return this.targetsBuilder;
        }

        public EdgeStep.Builder step() {
            EdgeStep.Builder builder;
            this.stepBuilder = builder = EdgeStep.builder();
            return builder;
        }

        public Builder maxDepth(int maxDepth) {
            TraversersAPI.checkPositive(maxDepth, "max depth");
            this.request.depth = maxDepth;
            return this;
        }

        public Builder nearest(boolean nearest) {
            this.request.nearest = nearest;
            return this;
        }

        public Builder capacity(long capacity) {
            TraversersAPI.checkCapacity(capacity);
            this.request.capacity = capacity;
            return this;
        }

        public Builder limit(int limit) {
            TraversersAPI.checkLimit(limit);
            this.request.limit = limit;
            return this;
        }

        public Builder withVertex(boolean withVertex) {
            this.request.withVertex = withVertex;
            return this;
        }

        public PathsRequest build() {
            this.request.sources = this.sourcesBuilder.build();
            E.checkArgument(this.request.sources != null, "Source vertices can't be null", new Object[0]);
            this.request.targets = this.targetsBuilder.build();
            E.checkArgument(this.request.targets != null, "Target vertices can't be null", new Object[0]);
            this.request.step = this.stepBuilder.build();
            E.checkNotNull(this.request.step, "The steps can't be null");
            TraversersAPI.checkPositive(this.request.depth, "max depth");
            TraversersAPI.checkCapacity(this.request.capacity);
            TraversersAPI.checkLimit(this.request.limit);
            return this.request;
        }
    }
}

