/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.worker;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.worker.Computation;
import org.apache.hugegraph.computer.core.worker.ComputationContext;
import org.apache.hugegraph.iterator.MapperIterator;

public interface FilterComputation<M extends Value>
extends Computation<M> {
    public M initialValue(ComputationContext var1, Vertex var2);

    @Override
    default public void compute0(ComputationContext context, Vertex vertex) {
        M result = this.initialValue(context, vertex);
        this.compute(context, vertex, Arrays.asList(result).iterator());
    }

    @Override
    default public void compute(ComputationContext context, Vertex vertex, Iterator<M> messages) {
        Iterator<M> results = this.computeMessages(context, vertex, messages);
        this.sendMessages(context, vertex, results);
        this.updateState(vertex);
    }

    default public Iterator<M> computeMessages(ComputationContext context, Vertex vertex, Iterator<M> messages) {
        return new MapperIterator<Value, Value>(messages, message -> this.computeMessage(context, vertex, message));
    }

    public M computeMessage(ComputationContext var1, Vertex var2, M var3);

    default public void sendMessages(ComputationContext context, Vertex vertex, Iterator<M> results) {
        context.sendMessagesToAllEdges(vertex, results);
    }

    default public void updateState(Vertex vertex) {
        vertex.inactivate();
    }
}

