/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface MemStore {
    public MemStoreSnapshot snapshot();

    public void clearSnapshot(long var1) throws UnexpectedStateException;

    public MemStoreSize getFlushableSize();

    public MemStoreSize getSnapshotSize();

    public void add(Cell var1, MemStoreSizing var2);

    public void add(Iterable<Cell> var1, MemStoreSizing var2);

    public long timeOfOldestEdit();

    public void upsert(Iterable<Cell> var1, long var2, MemStoreSizing var4);

    public List<KeyValueScanner> getScanners(long var1) throws IOException;

    public MemStoreSize size();

    public long preFlushSeqIDEstimation();

    public boolean isSloppy();

    default public void startReplayingFromWAL() {
    }

    default public void stopReplayingFromWAL() {
    }
}

